/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.IndexController;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManager;

public class SyncStatus {
    private final IoTConsensusConfig config;
    private final IndexController controller;
    private final LinkedList<Batch> pendingBatches = new LinkedList();
    private final IoTConsensusMemoryManager iotConsensusMemoryManager = IoTConsensusMemoryManager.getInstance();

    public SyncStatus(IndexController controller, IoTConsensusConfig config) {
        this.controller = controller;
        this.config = config;
    }

    public synchronized void addNextBatch(Batch batch) throws InterruptedException {
        while (this.pendingBatches.size() >= this.config.getReplication().getMaxPendingBatchesNum() || !this.iotConsensusMemoryManager.reserve(batch.getSerializedSize(), false)) {
            this.wait();
        }
        this.pendingBatches.add(batch);
    }

    public synchronized void removeBatch(Batch batch) {
        batch.setSynced(true);
        if (!this.pendingBatches.isEmpty() && this.pendingBatches.get(0).equals(batch)) {
            Iterator iterator = this.pendingBatches.iterator();
            Batch current = (Batch)iterator.next();
            while (current.isSynced()) {
                this.controller.update(current.getEndIndex(), false);
                iterator.remove();
                this.iotConsensusMemoryManager.free(current.getSerializedSize(), false);
                if (!iterator.hasNext()) break;
                current = (Batch)iterator.next();
            }
            this.notifyAll();
        }
    }

    public synchronized void free() {
        long size = 0L;
        for (Batch pendingBatch : this.pendingBatches) {
            size += pendingBatch.getSerializedSize();
        }
        this.pendingBatches.clear();
        this.controller.update(0L, true);
        this.iotConsensusMemoryManager.free(size, false);
    }

    public synchronized long getNextSendingIndex() {
        return 1L + (this.pendingBatches.isEmpty() ? this.controller.getCurrentIndex() : this.pendingBatches.getLast().getEndIndex());
    }

    public synchronized List<Batch> getPendingBatches() {
        return this.pendingBatches;
    }
}

