/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.storage.SnapshotEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class SnapshotEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class SnapshotEntrySerializerV2
    implements CatalogObjectSerializer<SnapshotEntry> {
        SnapshotEntrySerializerV2() {
        }

        @Override
        public SnapshotEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int catalogVersion = input.readVarIntAsInt();
            long activationTime = input.readLong();
            int objectIdGenState = input.readVarIntAsInt();
            List<CatalogZoneDescriptor> zones = input.readCompactEntryList(CatalogZoneDescriptor.class);
            List<CatalogSchemaDescriptor> schemas = input.readCompactEntryList(CatalogSchemaDescriptor.class);
            Integer defaultZoneId = null;
            if (input.readBoolean()) {
                defaultZoneId = input.readVarIntAsInt();
            }
            return new SnapshotEntry(catalogVersion, activationTime, objectIdGenState, zones.toArray(new CatalogZoneDescriptor[0]), schemas.toArray(new CatalogSchemaDescriptor[0]), defaultZoneId);
        }

        @Override
        public void writeTo(SnapshotEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.version());
            output.writeLong(entry.activationTime());
            output.writeVarInt(entry.objectIdGenState());
            output.writeCompactEntryList(Arrays.asList(entry.zones()));
            output.writeCompactEntryList(Arrays.asList(entry.schemas()));
            Integer defaultZoneId = entry.defaultZoneId();
            output.writeBoolean(defaultZoneId != null);
            if (defaultZoneId != null) {
                output.writeVarInt(defaultZoneId.intValue());
            }
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class SnapshotEntrySerializerV1
    implements CatalogObjectSerializer<SnapshotEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public SnapshotEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public SnapshotEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int catalogVersion = input.readVarIntAsInt();
            long activationTime = input.readLong();
            int objectIdGenState = input.readVarIntAsInt();
            CatalogObjectSerializer zoneSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_ZONE.id());
            CatalogObjectSerializer schemaSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SCHEMA.id());
            CatalogZoneDescriptor[] zones = CatalogSerializationUtils.readArray(zoneSerializer, input, CatalogZoneDescriptor.class);
            CatalogSchemaDescriptor[] schemas = CatalogSerializationUtils.readArray(schemaSerializer, input, CatalogSchemaDescriptor.class);
            Integer defaultZoneId = null;
            if (input.readBoolean()) {
                defaultZoneId = input.readVarIntAsInt();
            }
            return new SnapshotEntry(catalogVersion, activationTime, objectIdGenState, zones, schemas, defaultZoneId);
        }

        @Override
        public void writeTo(SnapshotEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.version());
            output.writeLong(entry.activationTime());
            output.writeVarInt(entry.objectIdGenState());
            CatalogObjectSerializer zoneDescSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_ZONE.id());
            CatalogObjectSerializer schemaDescSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_SCHEMA.id());
            CatalogSerializationUtils.writeArray(entry.zones(), zoneDescSerializer, output);
            CatalogSerializationUtils.writeArray(entry.schemas(), schemaDescSerializer, output);
            Integer defaultZoneId = entry.defaultZoneId();
            output.writeBoolean(defaultZoneId != null);
            if (defaultZoneId != null) {
                output.writeVarInt(defaultZoneId.intValue());
            }
        }
    }
}

