/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.containers.ElementContainerAdapter;
import org.datanucleus.store.types.containers.ElementContainerHandler;
import org.datanucleus.store.types.containers.MapContainerAdapter;
import org.datanucleus.store.types.containers.MapHandler;
import org.datanucleus.store.types.containers.SequenceAdapter;
import org.datanucleus.store.types.wrappers.Collection;
import org.datanucleus.util.NucleusLogger;

public class L2CachePopulateFieldManager
extends AbstractFieldManager {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    DNStateManager sm;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CachePopulateFieldManager(DNStateManager sm, CachedPC cachedpc) {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    @Override
    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Character.valueOf(value));
    }

    @Override
    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Float.valueOf(value));
    }

    @Override
    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (value != null && value instanceof Collection) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        if (value == null) {
            this.cachedPC.setFieldValue(fieldNumber, null);
        } else if (mmd.hasContainer()) {
            this.processContainer(fieldNumber, value, mmd);
        } else {
            this.processField(fieldNumber, value, mmd);
        }
    }

    private Object getCacheableIdForId(ApiAdapter api, Object pc) {
        if (pc == null) {
            return null;
        }
        Object id = api.getIdForObject(pc);
        if (IdentityUtils.isDatastoreIdentity(id) || IdentityUtils.isSingleFieldIdentity(id)) {
            return id;
        }
        return new CachedPC.CachedId(pc.getClass().getName(), id);
    }

    private void processContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd) {
        Object unwrappedContainer = container;
        if (container instanceof SCOContainer) {
            if (!((SCOContainer)container).isLoaded()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            unwrappedContainer = ((SCO)container).getValue();
        }
        TypeManager typeManager = this.sm.getExecutionContext().getTypeManager();
        if (mmd.hasMap()) {
            MapHandler mapHandler = (MapHandler)typeManager.getContainerHandler(mmd.getType());
            this.processMapContainer(fieldNumber, unwrappedContainer, mmd, mapHandler);
        } else {
            ElementContainerHandler elementContainerHandler = (ElementContainerHandler)typeManager.getContainerHandler(mmd.getType());
            this.processElementContainer(fieldNumber, unwrappedContainer, mmd, elementContainerHandler);
        }
    }

    private void processMapContainer(int fieldNumber, Object mapContainer, AbstractMemberMetaData mmd, MapHandler<Object> containerHandler) {
        try {
            RelationType relType;
            if (!this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheembedded") && (relType = mmd.getRelationType(this.ec.getClassLoaderResolver())) != RelationType.NONE && (containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd))) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            boolean keyIsPersistent = mmd.getMap().keyIsPersistent();
            boolean keyIsEmbedded = mmd.getMap().isEmbeddedKey();
            boolean keyIsSerialised = mmd.getMap().isSerializedKey();
            boolean valueIsPersistent = mmd.getMap().valueIsPersistent();
            boolean valueIsEmbedded = mmd.getMap().isEmbeddedValue();
            boolean valueIsSerialised = mmd.getMap().isSerializedValue();
            Object newContainer = L2CacheRetrieveFieldManager.newContainer(mapContainer, mmd, containerHandler);
            MapContainerAdapter mapToCacheAdapter = (MapContainerAdapter)containerHandler.getAdapter(newContainer);
            ApiAdapter api = this.ec.getApiAdapter();
            for (Map.Entry<Object, Object> entry : ((MapContainerAdapter)containerHandler.getAdapter(mapContainer)).entries()) {
                Object mapKey = null;
                mapKey = keyIsPersistent ? (keyIsEmbedded || keyIsSerialised || mmd.isSerialized() ? this.convertPersistableToCachedPC(entry.getKey()) : this.getCacheableIdForId(api, entry.getKey())) : SCOUtils.copyValue(entry.getKey());
                Object mapValue = null;
                mapValue = valueIsPersistent ? (valueIsEmbedded || valueIsSerialised || mmd.isSerialized() ? this.convertPersistableToCachedPC(entry.getValue()) : this.getCacheableIdForId(api, entry.getValue())) : SCOUtils.copyValue(entry.getValue());
                mapToCacheAdapter.put(mapKey, mapValue);
            }
            this.cachedPC.setFieldValue(fieldNumber, mapToCacheAdapter.getContainer());
        }
        catch (Exception e) {
            NucleusLogger.CACHE.warn("Unable to create object of type " + mapContainer.getClass().getName() + " for L2 caching", e);
            this.cachedPC.setLoadedField(fieldNumber, false);
        }
    }

    private void processElementContainer(int fieldNumber, Object container, AbstractMemberMetaData mmd, ElementContainerHandler<Object, ElementContainerAdapter<Object>> containerHandler) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            boolean isContainerMutable = this.ec.getTypeManager().isSecondClassMutableType(mmd.getType().getName());
            String elementType = containerHandler.getElementTypeName(mmd.getContainer());
            boolean isElementMutable = this.ec.getTypeManager().isSecondClassMutableType(elementType);
            if (isContainerMutable || isElementMutable) {
                ElementContainerAdapter adapterToCache = (ElementContainerAdapter)containerHandler.getAdapter(L2CacheRetrieveFieldManager.newContainer(container, mmd, containerHandler));
                if (isElementMutable) {
                    for (Object elementSCO : (ElementContainerAdapter)containerHandler.getAdapter(container)) {
                        adapterToCache.add(SCOUtils.copyValue(elementSCO));
                    }
                } else {
                    for (Object element : (ElementContainerAdapter)containerHandler.getAdapter(container)) {
                        adapterToCache.add(element);
                    }
                }
                this.cachedPC.setFieldValue(fieldNumber, adapterToCache.getContainer());
            } else {
                this.cachedPC.setFieldValue(fieldNumber, container);
            }
        } else {
            ElementContainerAdapter containerAdapter = (ElementContainerAdapter)containerHandler.getAdapter(container);
            if (containerAdapter instanceof SequenceAdapter && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            try {
                Object[] newContainer = mmd.hasArray() ? EMPTY_ARRAY : L2CacheRetrieveFieldManager.newContainer(container, mmd, containerHandler);
                ElementContainerAdapter containerToCacheAdapter = (ElementContainerAdapter)containerHandler.getAdapter(newContainer);
                ApiAdapter api = this.ec.getApiAdapter();
                if ((containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd)) && !this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheembedded")) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                for (Object element : containerAdapter) {
                    if (containerHandler.isSerialised(mmd) || containerHandler.isEmbedded(mmd)) {
                        containerToCacheAdapter.add(this.convertPersistableToCachedPC(element));
                        continue;
                    }
                    containerToCacheAdapter.add(this.getCacheableIdForId(api, element));
                }
                this.cachedPC.setFieldValue(fieldNumber, containerToCacheAdapter.getContainer());
            }
            catch (Exception e) {
                NucleusLogger.CACHE.warn("Unable to create object of type " + container.getClass().getName() + " for L2 caching : ", e);
                this.cachedPC.setLoadedField(fieldNumber, false);
            }
        }
    }

    private void processField(int fieldNumber, Object value, AbstractMemberMetaData mmd) {
        RelationType relType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (relType == RelationType.NONE) {
            Object unwrappedValue = value instanceof SCO ? ((SCO)value).getValue() : value;
            this.cachedPC.setFieldValue(fieldNumber, SCOUtils.copyValue(unwrappedValue));
            return;
        }
        if (mmd.isSerialized() || MetaDataUtils.isMemberEmbedded(mmd, relType, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) {
            if (this.ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheembedded")) {
                this.cachedPC.setFieldValue(fieldNumber, this.convertPersistableToCachedPC(value));
            } else {
                this.cachedPC.setLoadedField(fieldNumber, false);
            }
        } else {
            this.cachedPC.setFieldValue(fieldNumber, this.getCacheableIdForId(this.ec.getApiAdapter(), value));
        }
    }

    protected CachedPC convertPersistableToCachedPC(Object pc) {
        if (pc == null) {
            return null;
        }
        DNStateManager valueSM = this.ec.findStateManager(pc);
        CachedPC valueCachedPC = new CachedPC(pc.getClass(), valueSM.getLoadedFields(), null, null);
        int[] loadedFields = valueSM.getLoadedFieldNumbers();
        if (loadedFields != null && loadedFields.length > 0) {
            valueSM.provideFields(loadedFields, new L2CachePopulateFieldManager(valueSM, valueCachedPC));
        }
        return valueCachedPC;
    }
}

