/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;

public class AlterTableExecuteSpec<T> {
    private final ExecuteOperationType operationType;
    private final T operationParams;

    public AlterTableExecuteSpec(ExecuteOperationType type, T value) {
        this.operationType = type;
        this.operationParams = value;
    }

    public ExecuteOperationType getOperationType() {
        return this.operationType;
    }

    public T getOperationParams() {
        return this.operationParams;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operationType", (Object)this.operationType.name()).add("operationParams", this.operationParams).toString();
    }

    public static enum ExecuteOperationType {
        ROLLBACK,
        EXPIRE_SNAPSHOT,
        SET_CURRENT_SNAPSHOT,
        FAST_FORWARD,
        CHERRY_PICK,
        DELETE_METADATA,
        DELETE_ORPHAN_FILES;

    }

    public static class DeleteOrphanFilesDesc {
        private final long timestampMillis;

        public DeleteOrphanFilesDesc(long timestampMillis) {
            Preconditions.checkArgument((timestampMillis >= 0L ? 1 : 0) != 0, (Object)"TimeStamp Millis shouldn't be negative");
            this.timestampMillis = timestampMillis;
        }

        public long getTimestampMillis() {
            return this.timestampMillis;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timestampMillis", this.timestampMillis).toString();
        }
    }

    public static class DeleteMetadataSpec {
        private final String branchName;
        private final SearchArgument sarg;

        public DeleteMetadataSpec(String branchName, SearchArgument sarg) {
            this.branchName = branchName;
            this.sarg = sarg;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public SearchArgument getSarg() {
            return this.sarg;
        }
    }

    public static class CherryPickSpec {
        private final long snapshotId;

        public CherryPickSpec(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long getSnapshotId() {
            return this.snapshotId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("snapshotId", this.snapshotId).toString();
        }
    }

    public static class FastForwardSpec {
        private final String sourceBranch;
        private final String targetBranch;

        public FastForwardSpec(String sourceBranch, String targetBranch) {
            this.sourceBranch = sourceBranch;
            this.targetBranch = targetBranch;
        }

        public String getSourceBranch() {
            return this.sourceBranch;
        }

        public String getTargetBranch() {
            return this.targetBranch;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sourceBranch", (Object)this.sourceBranch).add("targetBranch", (Object)this.targetBranch).toString();
        }
    }

    public static class SetCurrentSnapshotSpec {
        private final String snapshotIdOrRefName;

        public SetCurrentSnapshotSpec(String snapshotIdOrRefName) {
            this.snapshotIdOrRefName = snapshotIdOrRefName;
        }

        public String getSnapshotIdOrRefName() {
            return this.snapshotIdOrRefName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("snapshotIdOrRefName", (Object)this.snapshotIdOrRefName).toString();
        }
    }

    public static class ExpireSnapshotsSpec {
        private long timestampMillis = -1L;
        private String[] idsToExpire = null;
        private long fromTimestampMillis = -1L;
        private int numRetainLast = -1;

        public ExpireSnapshotsSpec(long timestampMillis) {
            this.timestampMillis = timestampMillis;
        }

        public ExpireSnapshotsSpec(String ids) {
            this.idsToExpire = ids.split(",");
        }

        public ExpireSnapshotsSpec(long fromTimestampMillis, long toTimestampMillis) {
            this.fromTimestampMillis = fromTimestampMillis;
            this.timestampMillis = toTimestampMillis;
        }

        public ExpireSnapshotsSpec(int numRetainLast) {
            this.numRetainLast = numRetainLast;
        }

        public Long getTimestampMillis() {
            return this.timestampMillis;
        }

        public Long getFromTimestampMillis() {
            return this.fromTimestampMillis;
        }

        public String[] getIdsToExpire() {
            return this.idsToExpire;
        }

        public int getNumRetainLast() {
            return this.numRetainLast;
        }

        public boolean isExpireByIds() {
            return this.idsToExpire != null;
        }

        public boolean isExpireByTimestampRange() {
            return this.timestampMillis != -1L && this.fromTimestampMillis != -1L;
        }

        public boolean isExpireByRetainLast() {
            return this.numRetainLast != -1;
        }

        public String toString() {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this);
            if (this.isExpireByTimestampRange()) {
                stringHelper.add("fromTimestampMillis", this.fromTimestampMillis).add("toTimestampMillis", this.timestampMillis);
            } else if (this.isExpireByIds()) {
                stringHelper.add("idsToExpire", (Object)Arrays.toString(this.idsToExpire));
            } else if (this.isExpireByRetainLast()) {
                stringHelper.add("numRetainLast", this.numRetainLast);
            } else {
                stringHelper.add("timestampMillis", this.timestampMillis);
            }
            return stringHelper.toString();
        }
    }

    public static class RollbackSpec {
        private final RollbackType rollbackType;
        private final Long param;

        public RollbackSpec(RollbackType rollbackType, Long param) {
            this.rollbackType = rollbackType;
            this.param = param;
        }

        public RollbackType getRollbackType() {
            return this.rollbackType;
        }

        public Long getParam() {
            return this.param;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("rollbackType", (Object)this.rollbackType.name()).add("param", (Object)this.param).toString();
        }

        public static enum RollbackType {
            VERSION,
            TIME;

        }
    }
}

