/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringTrimColScalarBase;

public class StringLTrimColScalar
extends StringTrimColScalarBase {
    private static final long serialVersionUID = 1L;

    public StringLTrimColScalar(int inputColumn, byte[] trimChars, int outputColumnNum) {
        super(inputColumn, trimChars, outputColumnNum);
    }

    public StringLTrimColScalar() {
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int batchIndex) {
        int index;
        byte[] bytes = vector[batchIndex];
        int startIndex = start[batchIndex];
        int end = startIndex + length[batchIndex];
        for (index = startIndex; index < end && this.shouldTrim(bytes[index]); ++index) {
        }
        int resultLength = end - index;
        if (resultLength == 0) {
            outV.setVal(batchIndex, EMPTY_BYTES, 0, 0);
            return;
        }
        outV.setVal(batchIndex, bytes, index, resultLength);
    }
}

