/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.metastore;

import org.apache.derby.iapi.jdbc.AutoloadedDriver;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;

/**
 * Fake derby driver - companion class to enable testing by TestObjectStoreStatementVerify.
 * This derby driver will call a verifying function during prepareStatement.
 */
public class StatementVerifyingDerby extends AutoloadedDriver {

  @Override
  public boolean acceptsURL(String url) throws SQLException {
    url = url.replace("sderby", "derby");
    return super.acceptsURL(url);
  }

  @Override
  public Connection connect(String url, Properties info) throws SQLException {
    url = url.replace("sderby", "derby");
    return new StatementVerifyingDerby.StatementVerifyingConnection(super.connect(url, info));
  }

  @Override
  public Logger getParentLogger() throws SQLFeatureNotSupportedException {
    throw new SQLFeatureNotSupportedException();
  }

  public class StatementVerifyingConnection implements Connection {
    private java.sql.Connection _baseConn;

    public StatementVerifyingConnection(Connection connection) {
      this._baseConn = connection;
    }

    @Override
    public Statement createStatement() throws SQLException {
      return _baseConn.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
      return _baseConn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
      return _baseConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
      return _baseConn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
      return _baseConn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
      return _baseConn.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
      TestObjectStoreStatementVerify.verifySql(sql);
      return _baseConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
      return _baseConn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
      return _baseConn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
      return _baseConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
      return _baseConn.nativeSQL(sql);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
      return _baseConn.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
      _baseConn.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
      _baseConn.commit();
    }

    @Override
    public void rollback() throws SQLException {
      _baseConn.rollback();
    }

    @Override
    public void close() throws SQLException {
      _baseConn.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
      return _baseConn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
      return _baseConn.getMetaData();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
      return _baseConn.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
      _baseConn.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
      return _baseConn.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
      _baseConn.setCatalog(catalog);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
      return _baseConn.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
      _baseConn.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
      return _baseConn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
      _baseConn.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
      return _baseConn.createStatement(resultSetType, resultSetConcurrency);
    }


    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
      return _baseConn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
      _baseConn.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
      return _baseConn.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
      _baseConn.setHoldability(holdability);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
      return _baseConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
      return _baseConn.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
      _baseConn.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
      _baseConn.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
      return _baseConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }


    @Override
    public Clob createClob() throws SQLException {
      return _baseConn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
      return _baseConn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
      return _baseConn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
      return _baseConn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
      return _baseConn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
      _baseConn.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
      return _baseConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
      return _baseConn.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
      _baseConn.setClientInfo(properties);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
      return _baseConn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
      return _baseConn.createStruct(typeName, attributes);
    }

    @Override
    public String getSchema() throws SQLException {
      return _baseConn.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
      _baseConn.setSchema(schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
      _baseConn.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
      _baseConn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
      return _baseConn.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
      return _baseConn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
      return _baseConn.isWrapperFor(iface);
    }
  }
}
