/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseMetastoreOperations;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.hive.HiveHadoopUtil;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveOperationsBase;
import org.apache.iceberg.hive.LockException;
import org.apache.iceberg.hive.MetastoreLock;
import org.apache.iceberg.hive.NoLock;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOperations
extends BaseMetastoreTableOperations
implements HiveOperationsBase {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableOperations.class);
    private static final String HIVE_ICEBERG_METADATA_REFRESH_MAX_RETRIES = "iceberg.hive.metadata-refresh-max-retries";
    private static final int HIVE_ICEBERG_METADATA_REFRESH_MAX_RETRIES_DEFAULT = 2;
    private final String fullName;
    private final String catalogName;
    private final String database;
    private final String tableName;
    private final Configuration conf;
    private final long maxHiveTablePropertySize;
    private final int metadataRefreshMaxRetries;
    private final FileIO fileIO;
    private final ClientPool<IMetaStoreClient, TException> metaClients;

    protected HiveTableOperations(Configuration conf, ClientPool<IMetaStoreClient, TException> metaClients, FileIO fileIO, String catalogName, String database, String table) {
        this.conf = conf;
        this.metaClients = metaClients;
        this.fileIO = fileIO;
        this.fullName = catalogName + "." + database + "." + table;
        this.catalogName = catalogName;
        this.database = database;
        this.tableName = table;
        this.metadataRefreshMaxRetries = conf.getInt(HIVE_ICEBERG_METADATA_REFRESH_MAX_RETRIES, 2);
        this.maxHiveTablePropertySize = conf.getLong("iceberg.hive.table-property-max-size", 32672L);
    }

    protected String tableName() {
        return this.fullName;
    }

    public FileIO io() {
        return this.fileIO;
    }

    protected void doRefresh() {
        String metadataLocation = null;
        try {
            Table table = (Table)this.metaClients.run(client -> client.getTable(this.database, this.tableName));
            HiveOperationsBase.validateTableIsIceberg(table, this.fullName);
            metadataLocation = (String)table.getParameters().get("metadata_location");
        }
        catch (NoSuchObjectException e) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException("No such table: %s.%s", new Object[]{this.database, this.tableName});
            }
        }
        catch (TException e) {
            String errMsg = String.format("Failed to get table info from metastore %s.%s", this.database, this.tableName);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during refresh", e);
        }
        this.refreshFromMetadataLocation(metadataLocation, this.metadataRefreshMaxRetries);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        newTable = base == null;
        newMetadataLocation = this.writeNewMetadataIfRequired(newTable, metadata);
        hiveEngineEnabled = HiveTableOperations.hiveEngineEnabled(metadata, this.conf);
        keepHiveStats = this.conf.getBoolean("iceberg.hive.keep.stats", false);
        commitStatus = BaseMetastoreOperations.CommitStatus.FAILURE;
        updateHiveTable = false;
        lock = this.lockObject(base);
        try {
            lock.lock();
            tbl = this.loadHmsTable();
            if (tbl != null) {
                if (newTable && tbl.getParameters().get("metadata_location") != null) {
                    if (TableType.VIRTUAL_VIEW.name().equalsIgnoreCase(tbl.getTableType())) {
                        throw new AlreadyExistsException("View with same name already exists: %s.%s", new Object[]{this.database, this.tableName});
                    }
                    throw new AlreadyExistsException("Table already exists: %s.%s", new Object[]{this.database, this.tableName});
                }
                updateHiveTable = true;
                HiveTableOperations.LOG.debug("Committing existing table: {}", (Object)this.fullName);
            } else {
                tbl = this.newHmsTable(metadata.property("hive.metastore.table.owner", HiveHadoopUtil.currentUser()));
                HiveTableOperations.LOG.debug("Committing new table: {}", (Object)this.fullName);
            }
            tbl.setSd(HiveOperationsBase.storageDescriptor(metadata.schema(), metadata.location(), hiveEngineEnabled));
            metadataLocation = (String)tbl.getParameters().get("metadata_location");
            v0 = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
            if (!Objects.equals(baseMetadataLocation, metadataLocation)) {
                throw new CommitFailedException("Cannot commit: Base metadata location '%s' is not same as the current table metadata location '%s' for %s.%s", new Object[]{baseMetadataLocation, metadataLocation, this.database, this.tableName});
            }
            removedProps /* !! */  = Collections.emptySet();
            if (base != null) {
                removedProps /* !! */  = base.properties().keySet().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doCommit$1(org.apache.iceberg.TableMetadata java.lang.String ), (Ljava/lang/String;)Z)((TableMetadata)metadata)).collect(Collectors.toSet());
            }
            HMSTablePropertyHelper.updateHmsTableForIcebergTable(newMetadataLocation, tbl, metadata, removedProps /* !! */ , hiveEngineEnabled, this.maxHiveTablePropertySize, this.currentMetadataLocation());
            if (!keepHiveStats) {
                tbl.getParameters().remove("COLUMN_STATS_ACCURATE");
                tbl.getParameters().put("DO_NOT_UPDATE_STATS", "true");
            }
            lock.ensureActive();
            try {
                this.persistTable(tbl, updateHiveTable, HiveTableOperations.hiveLockEnabled(base, this.conf) != false ? null : baseMetadataLocation);
                lock.ensureActive();
                commitStatus = BaseMetastoreOperations.CommitStatus.SUCCESS;
            }
            catch (LockException le) {
                commitStatus = BaseMetastoreOperations.CommitStatus.UNKNOWN;
                throw new CommitStateUnknownException("Failed to heartbeat for hive lock while committing changes. This can lead to a concurrent commit attempt be able to overwrite this commit. Please check the commit history. If you are running into this issue, try reducing iceberg.hive.lock-heartbeat-interval-ms.", (Throwable)le);
            }
            catch (org.apache.hadoop.hive.metastore.api.AlreadyExistsException e) {
                throw new AlreadyExistsException((Throwable)e, "Table already exists: %s.%s", new Object[]{this.database, this.tableName});
            }
            catch (InvalidObjectException e) {
                throw new ValidationException((Throwable)e, "Invalid Hive object for %s.%s", new Object[]{this.database, this.tableName});
            }
            catch (CommitFailedException | CommitStateUnknownException e) {
                throw e;
            }
            catch (Throwable e) {
                if (e.getMessage() != null && e.getMessage().contains("Table/View 'HIVE_LOCKS' does not exist")) {
                    throw new RuntimeException("Failed to acquire locks from metastore because the underlying metastore table 'HIVE_LOCKS' does not exist. This can occur when using an embedded metastore which does not support transactions. To fix this use an alternative metastore.", e);
                }
                commitStatus = BaseMetastoreOperations.CommitStatus.UNKNOWN;
                if (e.getMessage() != null && e.getMessage().contains("The table has been modified. The parameter value for key 'metadata_location' is")) {
                    commitStatus = this.checkCommitStatusStrict(newMetadataLocation, metadata);
                    if (commitStatus == BaseMetastoreOperations.CommitStatus.FAILURE) {
                        throw new CommitFailedException(e, "The table %s.%s has been modified concurrently", new Object[]{this.database, this.tableName});
                    }
                } else {
                    HiveTableOperations.LOG.error("Cannot tell if commit to {}.{} succeeded, attempting to reconnect and check.", new Object[]{this.database, this.tableName, e});
                    commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
                }
                switch (1.$SwitchMap$org$apache$iceberg$BaseMetastoreOperations$CommitStatus[commitStatus.ordinal()]) {
                    case 1: {
                        ** break;
lbl64:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        throw e;
                    }
                    case 3: {
                        throw new CommitStateUnknownException(e);
                    }
                    ** default:
lbl70:
                    // 1 sources

                    break;
                }
            }
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s.%s", new Object[]{this.database, this.tableName}), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        catch (LockException e) {
            throw new CommitFailedException((Throwable)e);
        }
        finally {
            HiveOperationsBase.cleanupMetadataAndUnlock(this.io(), commitStatus, newMetadataLocation, lock);
        }
        HiveTableOperations.LOG.info("Committed to table {} with the new metadata location {}", (Object)this.fullName, (Object)newMetadataLocation);
    }

    @Override
    public long maxHiveTablePropertySize() {
        return this.maxHiveTablePropertySize;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public String table() {
        return this.tableName;
    }

    @Override
    public TableType tableType() {
        return TableType.EXTERNAL_TABLE;
    }

    @Override
    public ClientPool<IMetaStoreClient, TException> metaClients() {
        return this.metaClients;
    }

    private static boolean hiveEngineEnabled(TableMetadata metadata, Configuration conf) {
        if (metadata.properties().get("engine.hive.enabled") != null) {
            return metadata.propertyAsBoolean("engine.hive.enabled", false);
        }
        return conf.getBoolean("iceberg.engine.hive.enabled", false);
    }

    private static boolean hiveLockEnabled(TableMetadata metadata, Configuration conf) {
        if (metadata != null && metadata.properties().get("engine.hive.lock-enabled") != null) {
            return metadata.propertyAsBoolean("engine.hive.lock-enabled", false);
        }
        return conf.getBoolean("iceberg.engine.hive.lock-enabled", true);
    }

    @VisibleForTesting
    HiveLock lockObject(TableMetadata metadata) {
        if (HiveTableOperations.hiveLockEnabled(metadata, this.conf)) {
            return new MetastoreLock(this.conf, this.metaClients, this.catalogName, this.database, this.tableName);
        }
        return new NoLock();
    }

    private static /* synthetic */ boolean lambda$doCommit$1(TableMetadata metadata, String key) {
        return !metadata.properties().containsKey(key);
    }
}

