/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;

final class CompareAndCopy {
    private CompareAndCopy() {
    }

    static int compare(MemorySegment seg1, long offsetBytes1, long lengthBytes1, MemorySegment seg2, long offsetBytes2, long lengthBytes2) {
        MemorySegment slice2;
        MemorySegment slice1 = seg1.asSlice(offsetBytes1, lengthBytes1);
        long mm = slice1.mismatch(slice2 = seg2.asSlice(offsetBytes2, lengthBytes2));
        if (mm == -1L) {
            return 0;
        }
        if (lengthBytes1 > mm && lengthBytes2 > mm) {
            return Integer.compare(MemoryAccess.getByteAtOffset((MemorySegment)slice1, (long)mm) & 0xFF, MemoryAccess.getByteAtOffset((MemorySegment)slice2, (long)mm) & 0xFF);
        }
        if (lengthBytes1 == mm) {
            return -1;
        }
        return 1;
    }

    static boolean equals(MemorySegment seg1, MemorySegment seg2) {
        long cap2;
        long cap1 = seg1.byteSize();
        return cap1 == (cap2 = seg2.byteSize()) && CompareAndCopy.equals(seg1, 0L, seg2, 0L, cap1);
    }

    static boolean equals(MemorySegment seg1, long offsetBytes1, MemorySegment seg2, long offsetBytes2, long lengthBytes) {
        MemorySegment slice2;
        MemorySegment slice1 = seg1.asSlice(offsetBytes1, lengthBytes);
        return slice1.mismatch(slice2 = seg2.asSlice(offsetBytes2, lengthBytes)) == -1L;
    }

    static void copy(MemorySegment srcSegment, long srcOffsetBytes, MemorySegment dstSegment, long dstOffsetBytes, long lengthBytes) {
        MemorySegment srcSlice = srcSegment.asSlice(srcOffsetBytes, lengthBytes);
        MemorySegment dstSlice = dstSegment.asSlice(dstOffsetBytes, lengthBytes);
        dstSlice.copyFrom(srcSlice);
    }
}

