/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.FileProcessor;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.config.exclusion.plexus.MatchPattern;
import org.apache.rat.config.exclusion.plexus.MatchPatterns;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.DocumentNameMatcherSupplier;
import org.apache.rat.document.TraceableDocumentNameMatcher;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.ExtendedIterator;

public class ExclusionProcessor {
    private final Set<String> excludedPatterns = new HashSet<String>();
    private final List<DocumentNameMatcherSupplier> excludedPaths = new ArrayList<DocumentNameMatcherSupplier>();
    private final Set<String> includedPatterns = new HashSet<String>();
    private final List<DocumentNameMatcherSupplier> includedPaths = new ArrayList<DocumentNameMatcherSupplier>();
    private final Set<StandardCollection> fileProcessors = new HashSet<StandardCollection>();
    private final Set<StandardCollection> includedCollections = new HashSet<StandardCollection>();
    private final Set<StandardCollection> excludedCollections = new HashSet<StandardCollection>();
    private TraceableDocumentNameMatcher lastMatcher;
    private DocumentName lastMatcherBaseDir;

    private void resetLastMatcher() {
        this.lastMatcher = null;
        this.lastMatcherBaseDir = null;
    }

    public ExclusionProcessor addIncludedPatterns(Iterable<String> patterns) {
        ArrayList lst = new ArrayList();
        patterns.forEach(lst::add);
        DefaultLog.getInstance().info(String.format("Including patterns: %s", String.join((CharSequence)", ", lst)));
        this.includedPatterns.addAll(lst);
        this.resetLastMatcher();
        return this;
    }

    public ExclusionProcessor addIncludedFilter(DocumentNameMatcherSupplier matcherSupplier) {
        if (matcherSupplier != null) {
            this.includedPaths.add(matcherSupplier);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addFileProcessor(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Processing exclude file from %s.", new Object[]{collection}));
            this.fileProcessors.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addIncludedCollection(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Including %s collection.", new Object[]{collection}));
            this.includedCollections.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addExcludedPatterns(Iterable<String> patterns) {
        ArrayList lst = new ArrayList();
        patterns.forEach(lst::add);
        DefaultLog.getInstance().info(String.format("Excluding patterns: %s", String.join((CharSequence)", ", lst)));
        this.excludedPatterns.addAll(lst);
        this.resetLastMatcher();
        return this;
    }

    public ExclusionProcessor addExcludedFilter(DocumentNameMatcherSupplier matcherSupplier) {
        if (matcherSupplier != null) {
            this.excludedPaths.add(matcherSupplier);
            this.resetLastMatcher();
        }
        return this;
    }

    public ExclusionProcessor addExcludedCollection(StandardCollection collection) {
        if (collection != null) {
            DefaultLog.getInstance().info(String.format("Excluding %s collection.", new Object[]{collection}));
            this.excludedCollections.add(collection);
            this.resetLastMatcher();
        }
        return this;
    }

    private void segregateList(Set<String> matching, Set<String> notMatching, Collection<String> patterns) {
        if (!patterns.isEmpty()) {
            ExtendedIterator.create(patterns.iterator()).filter(ExclusionUtils.MATCH_FILTER).forEachRemaining(matching::add);
            ExtendedIterator.create(patterns.iterator()).filter(ExclusionUtils.NOT_MATCH_FILTER).map(s -> s.substring(1)).forEachRemaining(notMatching::add);
        }
    }

    public DocumentNameMatcher getNameMatcher(DocumentName basedir) {
        if (this.lastMatcher == null || !basedir.equals(this.lastMatcherBaseDir)) {
            this.lastMatcherBaseDir = basedir;
            TreeSet<String> incl = new TreeSet<String>();
            TreeSet<String> excl = new TreeSet<String>();
            for (StandardCollection sc : this.fileProcessors) {
                sc.fileProcessor().forEachRemaining(fp -> this.segregateList(excl, incl, (Collection)fp.apply(basedir)));
            }
            this.segregateList(incl, excl, (Collection)FileProcessor.from(this.includedPatterns).apply(basedir));
            this.segregateList(excl, incl, (Collection)FileProcessor.from(this.excludedPatterns).apply(basedir));
            for (StandardCollection sc : this.includedCollections) {
                this.segregateList(incl, excl, (Collection)FileProcessor.from(sc.patterns()).apply(basedir));
            }
            for (StandardCollection sc : this.excludedCollections) {
                this.segregateList(excl, incl, (Collection)FileProcessor.from(sc.patterns()).apply(basedir));
            }
            List inclMatchers = ExtendedIterator.create(this.includedCollections.iterator()).filter(StandardCollection::hasDocumentNameMatchSupplier).map(s -> TraceableDocumentNameMatcher.make(() -> "Path match " + s.name(), s.documentNameMatcherSupplier().get(basedir))).addTo(new ArrayList());
            List exclMatchers = ExtendedIterator.create(this.excludedCollections.iterator()).filter(StandardCollection::hasDocumentNameMatchSupplier).map(s -> TraceableDocumentNameMatcher.make(() -> "Path match " + s.name(), s.documentNameMatcherSupplier().get(basedir))).addTo(new ArrayList());
            if (!incl.isEmpty()) {
                inclMatchers.add(this.makeMatcher(() -> "included patterns", MatchPatterns.from(incl), basedir));
            }
            if (!excl.isEmpty()) {
                exclMatchers.add(this.makeMatcher(() -> "excluded patterns", MatchPatterns.from(excl), basedir));
            }
            if (!this.includedPaths.isEmpty()) {
                for (DocumentNameMatcherSupplier supplier : this.includedPaths) {
                    TraceableDocumentNameMatcher nameMatcher = TraceableDocumentNameMatcher.make(supplier::toString, supplier.get(basedir));
                    DefaultLog.getInstance().info(String.format("Including path matcher %s", nameMatcher));
                    inclMatchers.add(nameMatcher);
                }
            }
            if (!this.excludedPaths.isEmpty()) {
                for (DocumentNameMatcherSupplier supplier : this.excludedPaths) {
                    DocumentNameMatcher dnm = supplier.get(basedir);
                    TraceableDocumentNameMatcher pathMatcher = dnm instanceof DocumentNameMatcher ? (TraceableDocumentNameMatcher)dnm : TraceableDocumentNameMatcher.make(supplier::toString, supplier.get(basedir));
                    DefaultLog.getInstance().info(String.format("Excluding path matcher %s", pathMatcher));
                    exclMatchers.add(pathMatcher);
                }
            }
            this.lastMatcher = TraceableDocumentNameMatcher.TRUE;
            if (!exclMatchers.isEmpty()) {
                this.lastMatcher = TraceableDocumentNameMatcher.not(TraceableDocumentNameMatcher.or(exclMatchers));
                if (!inclMatchers.isEmpty()) {
                    this.lastMatcher = TraceableDocumentNameMatcher.or(TraceableDocumentNameMatcher.or(inclMatchers), this.lastMatcher);
                }
            }
        }
        return this.lastMatcher;
    }

    TraceableDocumentNameMatcher makeMatcher(Supplier<String> name, MatchPatterns patterns, DocumentName basedir) {
        return TraceableDocumentNameMatcher.make(name, p -> patterns.matches(p.getName(), MatchPattern.tokenizePathToString(p.getName(), basedir.getDirectorySeparator()), basedir.isCaseSensitive()));
    }
}

