/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynamic;

import java.util.Locale;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicAttributeIterator;
import org.apache.commons.jxpath.ri.model.dynamic.DynamicPropertyPointer;

public class DynamicPointer
extends PropertyOwnerPointer {
    private static final long serialVersionUID = -1842347025295904256L;
    private final QName qName;
    private final Object bean;
    private final DynamicPropertyHandler handler;

    public DynamicPointer(NodePointer parent, QName qName, Object bean, DynamicPropertyHandler handler) {
        super(parent);
        this.qName = qName;
        this.bean = bean;
        this.handler = handler;
    }

    public DynamicPointer(QName qName, Object bean, DynamicPropertyHandler handler, Locale locale) {
        super(null, locale);
        this.qName = qName;
        this.bean = bean;
        this.handler = handler;
    }

    @Override
    public String asPath() {
        return this.parent == null ? "/" : super.asPath();
    }

    @Override
    public NodeIterator attributeIterator(QName qName) {
        return new DynamicAttributeIterator(this, qName);
    }

    @Override
    public NodeIterator createNodeIterator(String property, boolean reverse, NodePointer startWith) {
        return new PropertyIterator(this, property, reverse, startWith);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynamicPointer)) {
            return false;
        }
        DynamicPointer other = (DynamicPointer)object;
        if (this.bean != other.bean) {
            return false;
        }
        return this.qName == other.qName || this.qName != null && this.qName.equals(other.qName);
    }

    @Override
    public Object getBaseValue() {
        return this.bean;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public QName getName() {
        return this.qName;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new DynamicPropertyPointer((NodePointer)this, this.handler);
    }

    public int hashCode() {
        return System.identityHashCode(this.bean) + (this.qName == null ? 0 : this.qName.hashCode());
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isDynamicPropertyDeclarationSupported() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }
}

