/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.Region;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.internal.HyperplaneSubsets;
import org.apache.commons.geometry.core.partitioning.EmbeddingHyperplane;
import org.apache.commons.geometry.euclidean.threed.AbstractPlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Bounds3D;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.PlaneSubset;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.BoundarySource2D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;

abstract class AbstractEmbeddedRegionPlaneSubset
extends AbstractPlaneSubset
implements PlaneSubset.Embedded {
    private final EmbeddingPlane plane;

    AbstractEmbeddedRegionPlaneSubset(EmbeddingPlane plane) {
        this.plane = plane;
    }

    @Override
    public EmbeddingPlane getPlane() {
        return this.plane;
    }

    @Override
    public EmbeddingPlane getHyperplane() {
        return this.getPlane();
    }

    public boolean isFull() {
        return this.getSubspaceRegion().isFull();
    }

    public boolean isEmpty() {
        return this.getSubspaceRegion().isEmpty();
    }

    public double getSize() {
        return this.getSubspaceRegion().getSize();
    }

    public Vector3D getCentroid() {
        Vector2D subspaceCentroid = (Vector2D)this.getSubspaceRegion().getCentroid();
        if (subspaceCentroid != null) {
            return this.getPlane().toSpace(subspaceCentroid);
        }
        return null;
    }

    public Vector3D toSpace(Vector2D pt) {
        return this.plane.toSpace(pt);
    }

    public Vector2D toSubspace(Vector3D pt) {
        return this.plane.toSubspace(pt);
    }

    public RegionLocation classify(Vector3D pt) {
        return HyperplaneSubsets.classifyAgainstEmbeddedRegion((Point)pt, (EmbeddingHyperplane)this.plane, (Region)this.getSubspaceRegion());
    }

    public Vector3D closest(Vector3D pt) {
        return (Vector3D)HyperplaneSubsets.closestToEmbeddedRegion((Point)pt, (EmbeddingHyperplane)this.plane, (Region)this.getSubspaceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[plane= ").append((Object)this.getPlane()).append(", subspaceRegion= ").append(this.getSubspaceRegion()).append(']');
        return sb.toString();
    }

    protected Bounds3D getBoundsFromSubspace(BoundarySource2D src) {
        Bounds2D subspaceBounds = src.getBounds();
        if (subspaceBounds != null) {
            Vector3D min = this.plane.toSpace((Vector2D)subspaceBounds.getMin());
            Vector3D max = this.plane.toSpace((Vector2D)subspaceBounds.getMax());
            return Bounds3D.builder().add(min).add(max).build();
        }
        return null;
    }
}

