/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;

public class CharReadBuffer {
    private static final int EOF = -1;
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private static final double LOG2 = Math.log(2.0);
    private final Reader reader;
    private char[] buffer;
    private int head;
    private int count;
    private boolean reachedEof;
    private final int minRead;

    public CharReadBuffer(Reader reader) {
        this(reader, 512);
    }

    public CharReadBuffer(Reader reader, int initialCapacity) {
        this(reader, initialCapacity, (initialCapacity + 1) / 2);
    }

    public CharReadBuffer(Reader reader, int initialCapacity, int minRead) {
        Objects.requireNonNull(reader, "Reader cannot be null");
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Initial buffer capacity must be greater than 0; was " + initialCapacity);
        }
        if (minRead < 1) {
            throw new IllegalArgumentException("Min read value must be greater than 0; was " + minRead);
        }
        this.reader = reader;
        this.buffer = new char[initialCapacity];
        this.minRead = minRead;
    }

    public boolean hasMoreCharacters() {
        return this.makeAvailable(1) > 0;
    }

    public int makeAvailable(int n) {
        int diff = n - this.count;
        if (diff > 0) {
            this.readChars(diff);
        }
        return this.count;
    }

    public int read() {
        int result = this.peek();
        this.charsRemoved(1);
        return result;
    }

    public String readString(int len) {
        String result = this.peekString(len);
        if (result != null) {
            this.charsRemoved(result.length());
        }
        return result;
    }

    public int peek() {
        if (this.makeAvailable(1) < 1) {
            return -1;
        }
        return this.buffer[this.head];
    }

    public String peekString(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested string length cannot be negative; was " + len);
        }
        if (len == 0) {
            return this.hasMoreCharacters() ? "" : null;
        }
        int available = this.makeAvailable(len);
        int resultLen = Math.min(len, available);
        if (resultLen < 1) {
            return null;
        }
        int contiguous = Math.min(this.buffer.length - this.head, resultLen);
        int remaining = resultLen - contiguous;
        String result = String.valueOf(this.buffer, this.head, contiguous);
        if (remaining > 0) {
            result = result + String.valueOf(this.buffer, 0, remaining);
        }
        return result;
    }

    public int charAt(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Character index cannot be negative; was " + index);
        }
        int requiredSize = index + 1;
        if (this.makeAvailable(requiredSize) < requiredSize) {
            return -1;
        }
        return this.buffer[(this.head + index) % this.buffer.length];
    }

    public int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Character skip count cannot be negative; was " + n);
        }
        int skipped = Math.min(n, this.count);
        this.charsRemoved(skipped);
        int remaining = n - skipped;
        if (remaining > 0) {
            try {
                skipped += (int)this.reader.skip(remaining);
            }
            catch (IOException exc) {
                throw GeometryIOUtils.createUnchecked(exc);
            }
        }
        return skipped;
    }

    public void push(char ch) {
        this.ensureCapacity(this.count + 1);
        this.pushCharInternal(ch);
    }

    public void pushString(String str) {
        int len = str.length();
        this.ensureCapacity(this.count + len);
        for (int i = len - 1; i >= 0; --i) {
            this.pushCharInternal(str.charAt(i));
        }
    }

    private void pushCharInternal(char ch) {
        this.charsPushed(1);
        this.buffer[this.head] = ch;
    }

    private void readChars(int n) {
        if (!this.reachedEof) {
            int remaining;
            this.ensureCapacity(this.count + remaining);
            try {
                int read;
                for (remaining = Math.max(n, this.minRead); remaining > 0; remaining -= read) {
                    int tail = (this.head + this.count) % this.buffer.length;
                    int len = Math.min(this.buffer.length - tail, remaining);
                    read = this.reader.read(this.buffer, tail, len);
                    if (read == -1) {
                        this.reachedEof = true;
                        break;
                    }
                    this.charsAppended(read);
                }
            }
            catch (IOException exc) {
                throw GeometryIOUtils.createUnchecked(exc);
            }
        }
    }

    private void charsRemoved(int n) {
        this.head = (this.head + n) % this.buffer.length;
        this.count -= n;
    }

    private void charsPushed(int n) {
        this.head = (this.head + this.buffer.length - n) % this.buffer.length;
        this.count += n;
    }

    private void charsAppended(int n) {
        this.count += n;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            double newCapacityPower = Math.ceil(Math.log(capacity) / LOG2);
            int newCapacity = (int)Math.pow(2.0, newCapacityPower);
            char[] newBuffer = new char[newCapacity];
            int contiguousCount = Math.min(this.count, this.buffer.length - this.head);
            System.arraycopy(this.buffer, this.head, newBuffer, 0, contiguousCount);
            if (contiguousCount < this.count) {
                System.arraycopy(this.buffer, 0, newBuffer, contiguousCount, this.count - contiguousCount);
            }
            this.buffer = newBuffer;
            this.head = 0;
        }
    }
}

