/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.bugs.other.Jira87BeanFactory;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.AbstractTestMap;

public class BeanMapTestCase
extends AbstractTestMap {
    private final Object objectInFullMap = new Object();

    public static void main(String[] args) {
        TestRunner.run((Test)BeanMapTestCase.suite());
    }

    public static Test suite() {
        return BulkTest.makeSuite(BeanMapTestCase.class);
    }

    public BeanMapTestCase(String testName) {
        super(testName);
    }

    public Object[] getNewSampleValues() {
        return new Object[]{223, 23341928234L, 23423.34, Float.valueOf(213332.12f), (short)234, (byte)20, Character.valueOf('b'), 232, "SomeNewStringValue", new Object(), null};
    }

    public Object[] getSampleKeys() {
        return new Object[]{"someIntValue", "someLongValue", "someDoubleValue", "someFloatValue", "someShortValue", "someByteValue", "someCharValue", "someIntegerValue", "someStringValue", "someObjectValue", "class"};
    }

    public Object[] getSampleValues() {
        return new Object[]{1234, 1298341928234L, 123423.34, Float.valueOf(1213332.1f), (short)134, (byte)10, Character.valueOf('a'), 1432, "SomeStringValue", this.objectInFullMap, BeanWithProperties.class};
    }

    public String[] ignoredTests() {
        return new String[]{"TestBeanMap.bulkTestMapEntrySet.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapEntrySet.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapKeySet.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapKeySet.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapValues.testCanonicalEmptyCollectionExists", "TestBeanMap.bulkTestMapValues.testCanonicalFullCollectionExists", "TestBeanMap.bulkTestMapEntrySet.testSimpleSerialization", "TestBeanMap.bulkTestMapKeySet.testSimpleSerialization", "TestBeanMap.bulkTestMapEntrySet.testSerializeDeserializeThenCompare", "TestBeanMap.bulkTestMapKeySet.testSerializeDeserializeThenCompare"};
    }

    public boolean isPutAddSupported() {
        return false;
    }

    public boolean isRemoveSupported() {
        return false;
    }

    public Map<Object, Object> makeEmptyMap() {
        return new BeanMap();
    }

    public Map<Object, Object> makeFullMap() {
        BeanWithProperties bean = new BeanWithProperties();
        bean.setSomeIntValue(1234);
        bean.setSomeLongValue(1298341928234L);
        bean.setSomeDoubleValue(123423.34);
        bean.setSomeFloatValue(1213332.1f);
        bean.setSomeShortValue((short)134);
        bean.setSomeByteValue((byte)10);
        bean.setSomeCharValue('a');
        bean.setSomeIntegerValue(1432);
        bean.setSomeStringValue("SomeStringValue");
        bean.setSomeObjectValue(this.objectInFullMap);
        return new BeanMap((Object)bean);
    }

    public void testBeanMapClone() {
        BeanMap map = (BeanMap)this.makeFullMap();
        try {
            Object[] keys;
            BeanMap map2 = (BeanMap)map.clone();
            for (Object key : keys = this.getSampleKeys()) {
                BeanMapTestCase.assertTrue((String)"Cloned BeanMap should contain the same keys", (boolean)map2.containsKey(key));
            }
        }
        catch (CloneNotSupportedException exception) {
            BeanMapTestCase.fail((String)"BeanMap.clone() should not throw a CloneNotSupportedException when clone should succeed.");
        }
    }

    public void testBeanMapPutAllWriteable() {
        BeanMap map1 = (BeanMap)this.makeFullMap();
        BeanMap map2 = (BeanMap)this.makeFullMap();
        map2.put((Object)"someIntValue", (Object)0);
        map1.putAllWriteable(map2);
        BeanMapTestCase.assertEquals((Object)map1.get((Object)"someIntValue"), (Object)0);
    }

    public void testDefaultTransformersMap() {
        BeanMapTestCase.assertEquals((String)"Size", (int)8, (int)BeanMap.defaultTransformers.size());
        BeanMapTestCase.assertEquals((String)"entrySet", (int)8, (int)BeanMap.defaultTransformers.entrySet().size());
        BeanMapTestCase.assertEquals((String)"keySet", (int)8, (int)BeanMap.defaultTransformers.size());
        BeanMapTestCase.assertEquals((String)"values", (int)8, (int)BeanMap.defaultTransformers.size());
        BeanMapTestCase.assertFalse((String)"isEmpty", (boolean)BeanMap.defaultTransformers.isEmpty());
        BeanMapTestCase.assertTrue((String)"containsKey(Double)", (boolean)BeanMap.defaultTransformers.containsKey(Double.TYPE));
        BeanMapTestCase.assertFalse((String)"containsKey(Object)", (boolean)BeanMap.defaultTransformers.containsKey(Object.class));
        BeanMapTestCase.assertTrue((String)"containsValue(double)", (boolean)BeanMap.defaultTransformers.containsValue(BeanMap.defaultTransformers.get(Double.TYPE)));
        BeanMapTestCase.assertFalse((String)"containsValue(Object)", (boolean)BeanMap.defaultTransformers.containsValue(Object.class));
        try {
            BeanMap.defaultTransformers.clear();
            BeanMapTestCase.fail((String)"clear() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            BeanMap.defaultTransformers.put("FOO", null);
            BeanMapTestCase.fail((String)"put() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            BeanMap.defaultTransformers.putAll(new HashMap());
            BeanMapTestCase.fail((String)"putAll() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            BeanMap.defaultTransformers.remove("FOO");
            BeanMapTestCase.fail((String)"remove() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testExceptionThrowFromClear() {
        try {
            Jira87BeanFactory.PublicMappedInterface bean = Jira87BeanFactory.createMappedPropertyBean();
            BeanMap map = new BeanMap((Object)bean);
            map.clear();
            BeanMapTestCase.fail((String)"clear() - expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Throwable cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                BeanMapTestCase.fail((String)("Retrieving the cause threw " + e2));
            }
            BeanMapTestCase.assertNotNull((String)"Cause null", (Object)cause);
            BeanMapTestCase.assertEquals((String)"Cause", NoSuchMethodException.class, cause.getClass());
        }
    }

    public void testExceptionThrowFromClone() {
        Throwable cause;
        try {
            Jira87BeanFactory.PublicMappedInterface bean = Jira87BeanFactory.createMappedPropertyBean();
            BeanMap map = new BeanMap((Object)bean);
            map.clone();
            BeanMapTestCase.fail((String)"Non-public bean clone() - expected CloneNotSupportedException");
        }
        catch (CloneNotSupportedException e) {
            cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                BeanMapTestCase.fail((String)("Non-public bean - retrieving the cause threw " + e2));
            }
            BeanMapTestCase.assertNotNull((String)"Non-public bean cause null", (Object)cause);
            BeanMapTestCase.assertEquals((String)"Non-public bean cause", NoSuchMethodException.class, cause.getClass());
        }
        try {
            BeanMap map = new BeanMap((Object)new BeanThrowingExceptions());
            map.clone();
            BeanMapTestCase.fail((String)"Setter Exception clone() - expected CloneNotSupportedException");
        }
        catch (CloneNotSupportedException e) {
            cause = null;
            try {
                cause = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
            }
            catch (Exception e2) {
                BeanMapTestCase.fail((String)("Setter Exception - retrieving the cause threw " + e2));
            }
            BeanMapTestCase.assertNotNull((String)"Setter Exception cause null", (Object)cause);
            BeanMapTestCase.assertEquals((String)"Setter Exception cause", IllegalArgumentException.class, cause.getClass());
        }
    }

    public void testExceptionThrowFromPut() {
        try {
            BeanMap map = new BeanMap((Object)new BeanThrowingExceptions());
            map.put("valueThrowingException", "value");
            BeanMapTestCase.fail((String)"Setter exception - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Throwable cause1 = null;
            Throwable cause2 = null;
            try {
                cause1 = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause");
                cause2 = (Throwable)PropertyUtils.getProperty((Object)e, (String)"cause.cause");
            }
            catch (Exception e2) {
                BeanMapTestCase.fail((String)("Setter exception - retrieving the cause threw " + e2));
            }
            BeanMapTestCase.assertNotNull((String)"Setter exception cause 1 null", (Object)cause1);
            BeanMapTestCase.assertEquals((String)"Setter exception cause 1", InvocationTargetException.class, cause1.getClass());
            BeanMapTestCase.assertNotNull((String)"Setter exception cause 2 null", (Object)cause2);
            BeanMapTestCase.assertEquals((String)"Setter exception cause 2", TestException.class, cause2.getClass());
        }
    }

    public void testGetDefaultTransformersMap() {
        BeanMapTestCase.assertEquals((String)"Boolean.TYPE", (Object)Boolean.TRUE, (Object)((Transformer)BeanMap.defaultTransformers.get(Boolean.TYPE)).transform((Object)"true"));
        BeanMapTestCase.assertEquals((String)"Character.TYPE", (Object)Character.valueOf('B'), (Object)((Transformer)BeanMap.defaultTransformers.get(Character.TYPE)).transform((Object)"BCD"));
        BeanMapTestCase.assertEquals((String)"Byte.TYPE", (Object)1, (Object)((Transformer)BeanMap.defaultTransformers.get(Byte.TYPE)).transform((Object)"1"));
        BeanMapTestCase.assertEquals((String)"Short.TYPE", (Object)2, (Object)((Transformer)BeanMap.defaultTransformers.get(Short.TYPE)).transform((Object)"2"));
        BeanMapTestCase.assertEquals((String)"Integer.TYPE", (Object)3, (Object)((Transformer)BeanMap.defaultTransformers.get(Integer.TYPE)).transform((Object)"3"));
        BeanMapTestCase.assertEquals((String)"Long.TYPE", (Object)4L, (Object)((Transformer)BeanMap.defaultTransformers.get(Long.TYPE)).transform((Object)"4"));
        BeanMapTestCase.assertEquals((String)"Float.TYPE", (Object)Float.valueOf("5"), (Object)((Transformer)BeanMap.defaultTransformers.get(Float.TYPE)).transform((Object)"5"));
        BeanMapTestCase.assertEquals((String)"Double.TYPE", (Object)Double.valueOf("6"), (Object)((Transformer)BeanMap.defaultTransformers.get(Double.TYPE)).transform((Object)"6"));
    }

    public void testGetTypeTransformerMethod() {
        BeanMap beanMap = new BeanMap();
        BeanMapTestCase.assertEquals((String)"Boolean.TYPE", (Object)Boolean.TRUE, (Object)beanMap.getTypeTransformer(Boolean.TYPE).transform((Object)"true"));
        BeanMapTestCase.assertEquals((String)"Character.TYPE", (Object)Character.valueOf('B'), (Object)beanMap.getTypeTransformer(Character.TYPE).transform((Object)"BCD"));
        BeanMapTestCase.assertEquals((String)"Byte.TYPE", (Object)1, (Object)beanMap.getTypeTransformer(Byte.TYPE).transform((Object)"1"));
        BeanMapTestCase.assertEquals((String)"Short.TYPE", (Object)2, (Object)beanMap.getTypeTransformer(Short.TYPE).transform((Object)"2"));
        BeanMapTestCase.assertEquals((String)"Integer.TYPE", (Object)3, (Object)beanMap.getTypeTransformer(Integer.TYPE).transform((Object)"3"));
        BeanMapTestCase.assertEquals((String)"Long.TYPE", (Object)4L, (Object)beanMap.getTypeTransformer(Long.TYPE).transform((Object)"4"));
        BeanMapTestCase.assertEquals((String)"Float.TYPE", (Object)Float.valueOf("5"), (Object)beanMap.getTypeTransformer(Float.TYPE).transform((Object)"5"));
        BeanMapTestCase.assertEquals((String)"Double.TYPE", (Object)Double.valueOf("6"), (Object)beanMap.getTypeTransformer(Double.TYPE).transform((Object)"6"));
    }

    public void testMapClear() {
    }

    public void testMapPut() {
    }

    public void testMethodAccessor() throws Exception {
        BeanMap map = (BeanMap)this.makeFullMap();
        Method method = BeanWithProperties.class.getDeclaredMethod("getSomeIntegerValue", new Class[0]);
        BeanMapTestCase.assertEquals((Object)method, (Object)map.getReadMethod("someIntegerValue"));
    }

    public void testMethodMutator() throws Exception {
        BeanMap map = (BeanMap)this.makeFullMap();
        Method method = BeanWithProperties.class.getDeclaredMethod("setSomeIntegerValue", Integer.class);
        BeanMapTestCase.assertEquals((Object)method, (Object)map.getWriteMethod("someIntegerValue"));
    }

    public void verifyValues() {
        this.values = this.map.values();
        super.verifyValues();
    }

    public static class BeanWithProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int someInt;
        private long someLong;
        private double someDouble;
        private float someFloat;
        private short someShort;
        private byte someByte;
        private char someChar;
        private Integer someInteger;
        private String someString;
        private Object someObject;

        public byte getSomeByteValue() {
            return this.someByte;
        }

        public char getSomeCharValue() {
            return this.someChar;
        }

        public double getSomeDoubleValue() {
            return this.someDouble;
        }

        public float getSomeFloatValue() {
            return this.someFloat;
        }

        public Integer getSomeIntegerValue() {
            return this.someInteger;
        }

        public int getSomeIntValue() {
            return this.someInt;
        }

        public long getSomeLongValue() {
            return this.someLong;
        }

        public Object getSomeObjectValue() {
            return this.someObject;
        }

        public short getSomeShortValue() {
            return this.someShort;
        }

        public String getSomeStringValue() {
            return this.someString;
        }

        public void setSomeByteValue(byte value) {
            this.someByte = value;
        }

        public void setSomeCharValue(char value) {
            this.someChar = value;
        }

        public void setSomeDoubleValue(double value) {
            this.someDouble = value;
        }

        public void setSomeFloatValue(float value) {
            this.someFloat = value;
        }

        public void setSomeIntegerValue(Integer value) {
            this.someInteger = value;
        }

        public void setSomeIntValue(int value) {
            this.someInt = value;
        }

        public void setSomeLongValue(long value) {
            this.someLong = value;
        }

        public void setSomeObjectValue(Object value) {
            this.someObject = value;
        }

        public void setSomeShortValue(short value) {
            this.someShort = value;
        }

        public void setSomeStringValue(String value) {
            this.someString = value;
        }
    }

    public static class BeanThrowingExceptions
    extends BeanWithProperties {
        private static final long serialVersionUID = 1L;

        public String getValueThrowingException() {
            throw new TestException();
        }

        public void setValueThrowingException(String value) {
            throw new TestException();
        }
    }

    public static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

