/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.data.RestoreJobProgressFetchPolicy;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.restore.RestoreJobConsistencyChecker;
import org.apache.cassandra.sidecar.restore.RestoreJobProgress;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class RestoreJobProgressHandler
extends AbstractHandler<RestoreJobProgressFetchPolicy>
implements AccessProtected {
    private final RestoreJobConsistencyChecker consistencyLevelChecker;

    @Inject
    public RestoreJobProgressHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, RestoreJobConsistencyChecker consistencyLevelChecker) {
        super(metadataFetcher, executorPools, validator);
        this.consistencyLevelChecker = consistencyLevelChecker;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected RestoreJobProgressFetchPolicy extractParamsOrThrow(RoutingContext context) {
        List fetchPolicyValues = context.queryParam("fetch-policy");
        if (fetchPolicyValues.isEmpty()) {
            this.logger.info("No RestoreJobProgressFetchPolicy is specified, FIRST_FAILED policy is assumed");
            return RestoreJobProgressFetchPolicy.FIRST_FAILED;
        }
        if (fetchPolicyValues.size() > 1) {
            this.logger.warn("Multiple RestoreJobProgressFetchPolicy are specified. Pick the first one.");
        }
        return RestoreJobProgressFetchPolicy.fromString((String)((String)fetchPolicyValues.get(0)));
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, RestoreJobProgressFetchPolicy fetchPolicy) {
        RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_RESTORE_JOB).map(this::validateSidecarManagedRestoreJob).compose(restoreJob -> this.consistencyLevelChecker.check((RestoreJob)restoreJob, fetchPolicy)).map(RestoreJobProgress::toResponsePayload).onSuccess(arg_0 -> ((RoutingContext)context).json(arg_0)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, fetchPolicy));
    }

    private RestoreJob validateSidecarManagedRestoreJob(RestoreJob restoreJob) {
        if (!restoreJob.isManagedBySidecar()) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Only Sidecar-managed restore jobs are allowed. jobId=" + restoreJob.jobId + " jobManager=" + restoreJob.restoreJobManager.name());
        }
        if (restoreJob.sliceCount == null) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Controller must set the sliceCount for Sidecar-managed restore job. jobId=" + restoreJob.jobId);
        }
        return restoreJob;
    }
}

