/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public class HttpClientConfig {
    public static final long DEFAULT_TIMEOUT_MILLIS = 30000L;
    public static final boolean DEFAULT_SSL = true;
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final String DEFAULT_USER_AGENT = "sidecar-client/0.1.0";
    public static final int DEFAULT_IDLE_TIMEOUT_MILLIS = 0;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 0x600000;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = -1;
    public static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    public static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    public static final String DEFAULT_KEY_STORE_TYPE = "PKCS12";
    public static final String DEFAULT_CASSANDRA_ROLE = null;
    private final long timeoutMillis;
    private final boolean ssl;
    private final int maxPoolSize;
    private final String userAgent;
    private final int idleTimeoutMillis;
    private final int maxChunkSize;
    private final int receiveBufferSize;
    private final int readBufferSize;
    private final InputStream trustStoreInputStream;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final InputStream keyStoreInputStream;
    private final String keyStorePassword;
    private final String keyStoreType;
    private final String cassandraRole;

    private HttpClientConfig(Builder<?> builder) {
        this.timeoutMillis = ((Builder)builder).timeoutMillis;
        this.ssl = ((Builder)builder).ssl;
        this.maxPoolSize = ((Builder)builder).maxPoolSize;
        this.userAgent = ((Builder)builder).userAgent;
        this.idleTimeoutMillis = builder.idleTimeoutMillis;
        this.maxChunkSize = ((Builder)builder).maxChunkSize;
        this.receiveBufferSize = ((Builder)builder).receiveBufferSize;
        this.readBufferSize = ((Builder)builder).readBufferSize;
        this.trustStoreInputStream = ((Builder)builder).trustStoreInputStream;
        this.trustStorePassword = ((Builder)builder).trustStorePassword;
        this.trustStoreType = ((Builder)builder).trustStoreType;
        this.keyStoreInputStream = ((Builder)builder).keyStoreInputStream;
        this.keyStorePassword = ((Builder)builder).keyStorePassword;
        this.keyStoreType = ((Builder)builder).keyStoreType;
        this.cassandraRole = ((Builder)builder).cassandraRole;
    }

    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    public boolean ssl() {
        return this.ssl;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public int idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public int receiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int sendReadBufferSize() {
        return this.readBufferSize;
    }

    public InputStream trustStoreInputStream() {
        return this.trustStoreInputStream;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public String trustStoreType() {
        return this.trustStoreType;
    }

    public InputStream keyStoreInputStream() {
        return this.keyStoreInputStream;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    @Nullable
    public String cassandraRole() {
        return this.cassandraRole;
    }

    public static class Builder<T extends Builder<T>> {
        private long timeoutMillis = 30000L;
        private boolean ssl = true;
        private int maxPoolSize = 20;
        public int idleTimeoutMillis = 0;
        private String userAgent = "sidecar-client/0.1.0";
        private int maxChunkSize = 0x600000;
        private int receiveBufferSize = -1;
        private int readBufferSize = 8192;
        private InputStream trustStoreInputStream;
        private String trustStorePassword;
        private String trustStoreType = "JKS";
        private InputStream keyStoreInputStream;
        private String keyStorePassword;
        private String keyStoreType = "PKCS12";
        private String cassandraRole = DEFAULT_CASSANDRA_ROLE;

        protected T self() {
            return (T)this;
        }

        public T timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this.self();
        }

        public T ssl(boolean ssl) {
            this.ssl = ssl;
            return this.self();
        }

        public T maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this.self();
        }

        public T userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this.self();
        }

        public T idleTimeoutMillis(int idleTimeoutMillis) {
            this.idleTimeoutMillis = idleTimeoutMillis;
            return this.self();
        }

        public T maxChunkSize(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
            return this.self();
        }

        public T receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this.self();
        }

        public T readBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this.self();
        }

        public T trustStoreInputStream(InputStream trustStoreInputStream) {
            this.trustStoreInputStream = trustStoreInputStream;
            return this.self();
        }

        public T trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this.self();
        }

        public T trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this.self();
        }

        public T keyStoreInputStream(InputStream keyStoreInputStream) {
            this.keyStoreInputStream = keyStoreInputStream;
            return this.self();
        }

        public T keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this.self();
        }

        public T keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this.self();
        }

        public T cassandraRole(String cassandraRole) {
            this.cassandraRole = cassandraRole;
            return this.self();
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this);
        }
    }
}

