/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class SmallInt
extends NativeType {
    public static final SmallInt INSTANCE = new SmallInt();

    public String name() {
        return "smallint";
    }

    @Override
    public AbstractType<?> dataType() {
        return ShortType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return (short)RandomUtils.RANDOM.nextInt(32768);
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setShort(position, ((Short)value).shortValue());
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.smallint();
    }
}

