/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.spark.data.types.BinaryBased;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Blob
extends BinaryBased {
    public static final Blob INSTANCE = new Blob();

    public String name() {
        return "blob";
    }

    @Override
    public AbstractType<?> dataType() {
        return BytesType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return RandomUtils.randomByteBuffer((int)RandomUtils.randomPositiveInt((int)256));
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setBytes(position, (ByteBuffer)value);
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.blob();
    }
}

