/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.json;

import java.util.function.Function;
import org.apache.avro.generic.GenericData;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.json.AvroJsonTransformer;
import org.apache.cassandra.cdc.json.CdcGenericData;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.schemastore.LocalTableSchemaStore;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.kafka.common.serialization.Serializer;

public class JsonSerializer
implements Serializer<CdcEvent> {
    private final AvroJsonTransformer transformer;

    public JsonSerializer(Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        this(LocalTableSchemaStore.getInstance(), typeLookup);
    }

    public JsonSerializer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup) {
        this.transformer = new AvroJsonTransformer(schemaStore, typeLookup);
    }

    public byte[] serialize(String topic, CdcEvent event) {
        GenericData.Record record = this.transformer.transform(event);
        return CdcGenericData.getInstance().toString(record).getBytes();
    }
}

