/*
 * Decompiled with CFR 0.152.
 */
package o.a.c.sidecar.client.shaded.io.vertx.core.http.impl;

import java.util.ArrayList;
import o.a.c.sidecar.client.shaded.io.netty.channel.ChannelPipeline;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import o.a.c.sidecar.client.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import o.a.c.sidecar.client.shaded.io.vertx.core.Handler;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpConnection;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.HttpServerRequest;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.ServerWebSocket;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.Http1xServerConnection;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.Http1xServerRequestHandler;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpServerConnection;
import o.a.c.sidecar.client.shaded.io.vertx.core.http.impl.HttpServerImpl;
import o.a.c.sidecar.client.shaded.io.vertx.core.impl.ContextInternal;

public class HttpServerConnectionHandler
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<HttpServerRequest> invalidRequestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpServerConnectionHandler(HttpServerImpl server, Handler<HttpServerRequest> requestHandler, Handler<HttpServerRequest> invalidRequestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server;
        this.requestHandler = requestHandler;
        this.invalidRequestHandler = invalidRequestHandler == null ? HttpServerRequest.DEFAULT_INVALID_REQUEST_HANDLER : invalidRequestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServerConnection conn) {
        Http1xServerRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new Http1xServerRequestHandler(this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebSocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        conn.invalidRequestHandler(this.invalidRequestHandler);
        if (this.connectionHandler != null) {
            ContextInternal ctx = conn.getContext();
            ContextInternal prev = ctx.beginDispatch();
            try {
                this.connectionHandler.handle(conn);
            }
            catch (Exception e) {
                ctx.reportException(e);
            }
            finally {
                ctx.endDispatch(prev);
            }
        }
    }

    private void initializeWebSocketExtensions(ChannelPipeline pipeline) {
        ArrayList<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();
        if (this.server.options.getPerFrameWebSocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebSocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebSocketAllowServerNoContext(), this.server.options.getWebSocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[0]));
            pipeline.addBefore("handler", "webSocketExtensionHandler", extensionHandler);
        }
    }
}

