/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.pager;

import java.io.Serializable;

public class PageControl
implements Serializable,
Cloneable {
    public static final int SIZE_UNLIMITED = -1;
    public static final int SORT_UNSORTED = 0;
    public static final int SORT_ASC = 1;
    public static final int SORT_DESC = 2;
    private int pagenum = 0;
    private int pagesize = -1;
    private int sortorder = 0;
    private int sortattribute = 0;
    private Serializable metaData;

    public PageControl() {
    }

    public PageControl(int pagenum, int pagesize) {
        this.pagenum = pagenum;
        this.pagesize = pagesize;
    }

    public PageControl(int pagenum, int pagesize, int sortorder, int sortattribute) {
        this.pagenum = pagenum;
        this.pagesize = pagesize;
        this.sortorder = sortorder;
        this.sortattribute = sortattribute;
    }

    public boolean isAscending() {
        return this.sortorder == 1;
    }

    public boolean isDescending() {
        return this.sortorder == 2;
    }

    public static PageControl initDefaults(PageControl pc, int defaultSortAttr) {
        if ((pc = pc == null ? new PageControl() : (PageControl)pc.clone()).getSortattribute() == 0) {
            pc.setSortattribute(defaultSortAttr);
        }
        if (pc.getSortorder() == 0) {
            pc.setSortorder(1);
        }
        return pc;
    }

    public int getPagenum() {
        return this.pagenum;
    }

    public void setPagenum(int pagenum) {
        this.pagenum = pagenum;
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }

    public int getSortorder() {
        return this.sortorder;
    }

    public void setSortorder(int sortorder) {
        this.sortorder = sortorder;
    }

    public int getSortattribute() {
        return this.sortattribute;
    }

    public void setSortattribute(int attr) {
        this.sortattribute = attr;
    }

    public Serializable getMetaData() {
        return this.metaData;
    }

    public void getMetaData(Serializable metaData) {
        this.metaData = metaData;
    }

    public int getPageEntityIndex() {
        return this.pagenum * this.pagesize;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer("{");
        s2.append("pn=" + this.pagenum + " ");
        s2.append("ps=" + this.pagesize + " ");
        s2.append("so=");
        switch (this.sortorder) {
            case 1: {
                s2.append("asc ");
                break;
            }
            case 2: {
                s2.append("desc");
                break;
            }
            case 0: {
                s2.append("unsorted ");
                break;
            }
            default: {
                s2.append(' ');
            }
        }
        s2.append("sa=" + this.sortattribute + " ");
        s2.append("}");
        return s2.toString();
    }

    public Object clone() {
        PageControl res = new PageControl(this.pagenum, this.pagesize, this.sortorder, this.sortattribute);
        res.metaData = this.metaData;
        return res;
    }
}

