/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.hflame;

import java.awt.Color;
import org.gridkit.jvmtool.hflame.FrameColorChooser;
import org.gridkit.jvmtool.stacktrace.StackFrame;

public class DefaultFrameColorChooser
implements FrameColorChooser {
    private final int baseHue;
    private final int deltaHue;

    public DefaultFrameColorChooser() {
        this.baseHue = 12;
        this.deltaHue = 10;
    }

    @Override
    public int getFrameColor(String frame) {
        if (frame.startsWith("(")) {
            return -1;
        }
        int c = DefaultFrameColorChooser.hashColor(this.baseHue, this.deltaHue, this.className(frame), this.methodName(frame));
        return c;
    }

    private String className(String frame) {
        int ch = frame.indexOf(40);
        if (ch >= 0) {
            frame = frame.substring(0, ch);
        }
        if ((ch = frame.lastIndexOf(46)) >= 0) {
            return frame.substring(0, ch);
        }
        return frame;
    }

    private String methodName(String frame) {
        int ch = frame.indexOf(40);
        if (ch >= 0) {
            frame = frame.substring(0, ch);
        }
        if ((ch = frame.lastIndexOf(46)) >= 0) {
            return frame.substring(ch + 1);
        }
        return "";
    }

    public static int hashColor(int baseHue, int deltaHue, String className, String methodName) {
        int hP = DefaultFrameColorChooser.packageNameHash(className);
        int hC = DefaultFrameColorChooser.classNameHash(className);
        int hM = methodName.hashCode();
        int hue = 0xFF & (deltaHue == 0 ? baseHue : baseHue + hP % (2 * deltaHue) - deltaHue);
        int sat = 180 + hC % 20 - 10;
        int lum = 220 + hM % 20 - 10;
        int c = Color.HSBtoRGB((float)hue / 255.0f, (float)sat / 255.0f, (float)lum / 255.0f);
        return 0xFFFFFF & c;
    }

    public static int hashGrayColor(StackFrame sf) {
        int hC = DefaultFrameColorChooser.classNameHash(sf.getClassName());
        int hM = sf.getMethodName().hashCode();
        boolean hue = false;
        boolean sat = false;
        int lum = 220 + (hM + hC) % 20 - 10;
        int c = Color.HSBtoRGB((float)hue / 255.0f, (float)sat / 255.0f, (float)lum / 255.0f);
        return c;
    }

    private static int packageNameHash(String className) {
        int c = className.lastIndexOf(46);
        if (c >= 0) {
            return className.substring(0, c).hashCode();
        }
        return 0;
    }

    private static int classNameHash(String className) {
        int c = className.lastIndexOf(46);
        if (c >= 0) {
            className = className.substring(c + 1);
        }
        if ((c = className.indexOf(36)) >= 0) {
            int nhash = className.substring(0, c).hashCode();
            int shash = className.substring(c + 1).hashCode();
            return nhash + shash % 10;
        }
        return className.hashCode();
    }
}

