/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.concurrent.TimeUnit;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cli.TimeIntervalConverter;
import org.gridkit.lab.jvm.attach.HeapHisto;
import org.gridkit.lab.jvm.perfdata.JStatData;

public class HeapHistoCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "hh";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new Histo(host);
    }

    @Parameters(commandDescription="[Heap Histo] Prints class histogram, similar to jmap -histo")
    public static class Histo
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @Parameter(names={"-p", "--pid"}, description="Process ID", required=true)
        private int pid;
        @Parameter(names={"--live"}, description="Live objects histogram")
        private boolean live = false;
        @Parameter(names={"--dead"}, description="Dead objects histogram")
        private boolean dead = false;
        @Parameter(names={"--dead-young"}, description="Histogram for sample of dead young objects")
        private boolean deadYoung = false;
        @Parameter(names={"--young"}, description="Histogram for sample of new objects")
        private boolean young = false;
        @Parameter(names={"-d", "--sample-depth"}, converter=TimeIntervalConverter.class, description="Used with --dead-young and --young options. Specific time duration to collect young population.")
        private long youngSampleDepth = 10000L;
        @Parameter(names={"-n", "--top-number"}, description="Show only N top buckets")
        private int n = Integer.MAX_VALUE;

        public Histo(CommandLauncher host) {
            this.host = host;
        }

        @Override
        public void run() {
            try {
                int x = 0;
                x += this.live ? 1 : 0;
                x += this.dead ? 1 : 0;
                x += this.deadYoung ? 1 : 0;
                if ((x += this.young ? 1 : 0) > 1) {
                    this.host.failAndPrintUsage("--live, --dead, --young and --deadYoung are mutually exclusive");
                }
                HeapHisto histo = this.live ? HeapHisto.getHistoLive(this.pid, 300000L) : (this.dead ? HeapHisto.getHistoDead(this.pid, 300000L) : (this.deadYoung ? this.collectDeadYoung() : (this.young ? this.collectYoung() : HeapHisto.getHistoAll(this.pid, 300000L))));
                System.out.println(String.format("%4s %14s%15s  %s", "#", "Instances", "Bytes", "Type"));
                System.out.println(histo.print(this.n));
            }
            catch (Exception e) {
                this.host.fail(e.toString(), e);
            }
        }

        private HeapHisto collectDeadYoung() throws InterruptedException {
            long sleepTime;
            long ygc = 0L;
            JStatData.LongCounter youngGcCnt = null;
            try {
                JStatData jsd = JStatData.connect(this.pid);
                youngGcCnt = (JStatData.LongCounter)jsd.getAllCounters().get("sun.gc.collector.0.invocations");
                ygc = youngGcCnt == null ? 0L : youngGcCnt.getLong();
            }
            catch (Exception e) {
                // empty catch block
            }
            HeapHisto.getHistoLive(this.pid, 3000000L);
            System.out.println("Gathering young garbage ...");
            long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.youngSampleDepth);
            while (System.nanoTime() < deadline && (sleepTime = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
                Thread.sleep(sleepTime);
            }
            HeapHisto histo = HeapHisto.getHistoDead(this.pid, 300000L);
            if (youngGcCnt != null && ygc != youngGcCnt.getLong()) {
                System.out.println("Warning: one or more young collections have occured during sampling.");
                System.out.println("Use --sample-depth option to reduce time to sample if needed.");
            }
            if (this.youngSampleDepth % 1000L == 0L) {
                System.out.println("Garbage histogram for last " + this.youngSampleDepth / 1000L + "s");
            } else {
                System.out.println("Garbage histogram for last " + this.youngSampleDepth + "ms");
            }
            return histo;
        }

        private HeapHisto collectYoung() throws InterruptedException {
            long sleepTime;
            long ygc = 0L;
            JStatData.LongCounter youngGcCnt = null;
            try {
                JStatData jsd = JStatData.connect(this.pid);
                youngGcCnt = (JStatData.LongCounter)jsd.getAllCounters().get("sun.gc.collector.0.invocations");
                ygc = youngGcCnt == null ? 0L : youngGcCnt.getLong();
            }
            catch (Exception e) {
                // empty catch block
            }
            HeapHisto retained = HeapHisto.getHistoLive(this.pid, 3000000L);
            System.out.println("Gathering young population ...");
            long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.youngSampleDepth);
            while (System.nanoTime() < deadline && (sleepTime = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
                Thread.sleep(sleepTime);
            }
            HeapHisto histo = HeapHisto.getHistoAll(this.pid, 300000L);
            if (youngGcCnt != null && ygc != youngGcCnt.getLong()) {
                System.out.println("Warning: one or more young collections have occured during sampling.");
                System.out.println("Use --sample-depth option to reduce time to sample if needed.");
            }
            if (this.youngSampleDepth % 1000L == 0L) {
                System.out.println("Garbage histogram for last " + this.youngSampleDepth / 1000L + "s");
            } else {
                System.out.println("Garbage histogram for last " + this.youngSampleDepth + "ms");
            }
            return HeapHisto.subtract(histo, retained);
        }
    }
}

