/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.cassandra.utils.AsymmetricOrdering;

public class Interval<C, D> {
    public final C min;
    public final C max;
    public final D data;
    private static final AsymmetricOrdering<Interval<Comparable, Comparable>, Comparable> minOrdering = new AsymmetricOrdering<Interval<Comparable, Comparable>, Comparable>(){

        @Override
        public int compareAsymmetric(Interval<Comparable, Comparable> left, Comparable right) {
            return ((Comparable)left.min).compareTo(right);
        }

        @Override
        public int compare(Interval<Comparable, Comparable> i1, Interval<Comparable, Comparable> i2) {
            int cmpMin = ((Comparable)i1.min).compareTo(i2.min);
            if (cmpMin != 0) {
                return cmpMin;
            }
            int cmpMax = ((Comparable)i1.max).compareTo(i2.max);
            if (cmpMax != 0) {
                return cmpMax;
            }
            return i1.data == i2.data ? 0 : ((Comparable)i1.data).compareTo(i2.data);
        }
    };
    private static final AsymmetricOrdering<Interval<Comparable, Comparable>, Comparable> maxOrdering = new AsymmetricOrdering<Interval<Comparable, Comparable>, Comparable>(){

        @Override
        public int compareAsymmetric(Interval<Comparable, Comparable> left, Comparable right) {
            return ((Comparable)left.max).compareTo(right);
        }

        @Override
        public int compare(Interval<Comparable, Comparable> i1, Interval<Comparable, Comparable> i2) {
            int cmpMax = ((Comparable)i1.max).compareTo(i2.max);
            if (cmpMax != 0) {
                return cmpMax;
            }
            int cmpMin = ((Comparable)i1.min).compareTo(i2.min);
            if (cmpMin != 0) {
                return cmpMin;
            }
            return i1.data == i2.data ? 0 : ((Comparable)i1.data).compareTo(i2.data);
        }
    };
    private static final AsymmetricOrdering<Interval<Comparable, Comparable>, Comparable> reverseMaxOrdering = maxOrdering.reverse();

    public Interval(C min2, C max, D data) {
        Preconditions.checkNotNull(min2, "min is null");
        Preconditions.checkNotNull(max, "max is null");
        this.min = min2;
        this.max = max;
        this.data = data;
    }

    public static <C, D> Interval<C, D> create(C min2, C max) {
        return Interval.create(min2, max, null);
    }

    public static <C, D> Interval<C, D> create(C min2, C max, D data) {
        return new Interval<C, D>(min2, max, data);
    }

    public String toString() {
        return String.format("[%s, %s]%s", this.min, this.max, this.data == null ? "" : String.format("(%s)", this.data));
    }

    public final int hashCode() {
        return Objects.hashCode(this.min, this.max, this.data);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval that = (Interval)o;
        return Objects.equal(this.min, that.min) && Objects.equal(this.max, that.max) && Objects.equal(this.data, that.data);
    }

    public static <C extends Comparable<? super C>, V> AsymmetricOrdering<Interval<C, V>, C> minOrdering() {
        return minOrdering;
    }

    public static <C extends Comparable<? super C>, V> AsymmetricOrdering<Interval<C, V>, C> maxOrdering() {
        return maxOrdering;
    }
}

