/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import io.netty.buffer.ByteBuf;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedMessageCodec<T extends Message>
implements Message.Codec<T> {
    public static final UnsupportedMessageCodec instance = new UnsupportedMessageCodec();
    private static final Logger logger = LoggerFactory.getLogger(UnsupportedMessageCodec.class);

    @Override
    public T decode(ByteBuf body, ProtocolVersion version) {
        if (ProtocolVersion.SUPPORTED.contains(version)) {
            logger.error("Received invalid message for supported protocol version {}", (Object)version);
        }
        throw new ProtocolException("Unsupported message");
    }

    @Override
    public void encode(T t2, ByteBuf dest, ProtocolVersion version) {
        throw new ProtocolException("Unsupported message");
    }

    @Override
    public int encodedSize(T t2, ProtocolVersion version) {
        return 0;
    }
}

