/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.uncommitted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.uncommitted.PaxosKeyState;
import org.apache.cassandra.service.paxos.uncommitted.UncommittedDataFile;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncommittedTableData {
    private static final Logger logger = LoggerFactory.getLogger(UncommittedTableData.class);
    private static final Collection<Range<Token>> FULL_RANGE;
    private static final SchemaElement UNKNOWN_TABLE;
    private static final ExecutorPlus executor;
    private final File directory;
    private final TableId tableId;
    private final FilterFactory filterFactory;
    private volatile Data data;
    private volatile Merge merge;
    private volatile boolean rebuilding = false;
    private int nextGeneration;
    private final NavigableSet<Integer> activeFlushes = new ConcurrentSkipListSet<Integer>();

    private static CloseableIterator<PaxosKeyState> merge(Collection<UncommittedDataFile> files, Collection<Range<Token>> ranges) {
        ArrayList<CloseableIterator<PaxosKeyState>> iterators = new ArrayList<CloseableIterator<PaxosKeyState>>(files.size());
        try {
            for (UncommittedDataFile file : files) {
                CloseableIterator<PaxosKeyState> iterator = file.iterator(ranges);
                if (iterator == null) continue;
                iterators.add(iterator);
            }
            return MergeIterator.get(iterators, PaxosKeyState.KEY_COMPARATOR, new Reducer());
        }
        catch (Throwable t2) {
            Throwables.close(t2, iterators);
            throw t2;
        }
    }

    private UncommittedTableData(File directory, TableId tableId, FilterFactory filterFactory, Data data) {
        this.directory = directory;
        this.tableId = tableId;
        this.filterFactory = filterFactory;
        this.data = data;
        this.nextGeneration = 1 + (int)data.files.stream().mapToLong(UncommittedDataFile::generation).max().orElse(-1L);
    }

    static UncommittedTableData load(File directory, TableId tableId, FilterFactory flushFilterFactory) {
        Matcher matcher;
        Preconditions.checkArgument(directory.exists());
        Preconditions.checkArgument(directory.isDirectory());
        Preconditions.checkNotNull(tableId);
        String[] fnames = directory.tryListNames();
        Preconditions.checkArgument(fnames != null);
        Pattern pattern = UncommittedDataFile.fileRegexFor(tableId);
        HashSet<Long> generations = new HashSet<Long>();
        ArrayList<UncommittedDataFile> files = new ArrayList<UncommittedDataFile>();
        for (String fname : fnames) {
            matcher = pattern.matcher(fname);
            if (!matcher.matches()) continue;
            File file = new File(directory, fname);
            if (UncommittedDataFile.isTmpFile(fname)) {
                logger.info("deleting left over uncommitted paxos temp file {} for tableId {}", (Object)file, (Object)tableId);
                file.delete();
                continue;
            }
            if (UncommittedDataFile.isCrcFile(fname)) continue;
            File crcFile = new File(directory, UncommittedDataFile.crcName(fname));
            if (!crcFile.exists()) {
                throw new FSReadError((Throwable)new IOException(String.format("%s does not have a corresponding crc file", file)), crcFile);
            }
            long generation = Long.parseLong(matcher.group(1));
            files.add(UncommittedDataFile.create(tableId, file, crcFile, generation));
            generations.add(generation);
        }
        for (String fname : fnames) {
            long generation;
            if (!UncommittedDataFile.isCrcFile(fname) || !(matcher = pattern.matcher(fname)).matches() || generations.contains(generation = Long.parseLong(matcher.group(1)))) continue;
            File file = new File(directory, fname);
            logger.info("deleting left over uncommitted paxos crc file {} for tableId {}", (Object)file, (Object)tableId);
            file.delete();
        }
        return new UncommittedTableData(directory, tableId, flushFilterFactory, new Data(ImmutableSet.copyOf(files)));
    }

    static UncommittedTableData load(File directory, TableId tableId) {
        return UncommittedTableData.load(directory, tableId, new CFSFilterFactory(tableId));
    }

    static Set<TableId> listTableIds(File directory) {
        Preconditions.checkArgument(directory.isDirectory());
        return UncommittedDataFile.listTableIds(directory);
    }

    private static SchemaElement tableName(TableId tableId) {
        TableMetadata name = Schema.instance.getTableMetadata(tableId);
        return name != null ? name : UNKNOWN_TABLE;
    }

    int numFiles() {
        return this.data.files.size();
    }

    TableId tableId() {
        return this.tableId;
    }

    public String keyspace() {
        return UncommittedTableData.tableName(this.tableId).elementKeyspace();
    }

    public String table() {
        return UncommittedTableData.tableName(this.tableId).elementName();
    }

    synchronized CloseableIterator<PaxosKeyState> iterator(Collection<Range<Token>> ranges) {
        Preconditions.checkArgument(Iterables.elementsEqual(Range.normalize(ranges), ranges));
        return this.filterFactory.filter(UncommittedTableData.merge(this.data.files, ranges));
    }

    private void flushTerminated(int generation) {
        this.activeFlushes.remove(generation);
        if (this.merge != null) {
            this.merge.maybeSchedule();
        }
    }

    private synchronized void flushSuccess(int generation, UncommittedDataFile newFile) {
        assert (newFile == null || (long)generation == newFile.generation());
        if (newFile != null) {
            this.data = this.data.withFile(newFile);
        }
        this.flushTerminated(generation);
    }

    private synchronized void flushAborted(int generation) {
        this.flushTerminated(generation);
    }

    private synchronized void mergeComplete(Merge merge, UncommittedDataFile newFile) {
        Preconditions.checkArgument(this.merge == merge);
        ImmutableSet.Builder files = ImmutableSet.builder();
        files.add(newFile);
        for (UncommittedDataFile file : this.data.files) {
            if (file.generation() > (long)merge.generation) {
                files.add(file);
                continue;
            }
            file.markDeleted();
        }
        this.data = new Data((ImmutableSet<UncommittedDataFile>)files.build());
        this.merge = null;
        logger.info("paxos uncommitted merge completed for {}.{}, new generation {} file added", new Object[]{this.keyspace(), this.table(), newFile.generation()});
    }

    synchronized FlushWriter flushWriter() throws IOException {
        final int generation = this.nextGeneration++;
        final UncommittedDataFile.Writer writer = UncommittedDataFile.writer(this.directory, this.keyspace(), this.table(), this.tableId, generation);
        this.activeFlushes.add(generation);
        logger.info("flushing generation {} uncommitted paxos file for {}.{}", new Object[]{generation, this.keyspace(), this.table()});
        return new FlushWriter(){

            @Override
            public void append(PaxosKeyState commitState) throws IOException {
                writer.append(commitState);
            }

            @Override
            public void finish() {
                UncommittedTableData.this.flushSuccess(generation, writer.finish());
            }

            @Override
            public Throwable abort(Throwable accumulate) {
                accumulate = writer.abort(accumulate);
                UncommittedTableData.this.flushAborted(generation);
                return accumulate;
            }
        };
    }

    private synchronized void rebuildComplete(UncommittedDataFile file) {
        Preconditions.checkState(this.rebuilding);
        Preconditions.checkState(!this.hasInProgressIO());
        Preconditions.checkState(this.data.files.isEmpty());
        this.data = new Data(ImmutableSet.of(file));
        logger.info("paxos rebuild completed for {}.{}", (Object)this.keyspace(), (Object)this.table());
        this.rebuilding = false;
    }

    synchronized FlushWriter rebuildWriter() throws IOException {
        Preconditions.checkState(!this.rebuilding);
        Preconditions.checkState(this.nextGeneration == 0);
        Preconditions.checkState(!this.hasInProgressIO());
        this.rebuilding = true;
        int generation = this.nextGeneration++;
        final UncommittedDataFile.Writer writer = UncommittedDataFile.writer(this.directory, this.keyspace(), this.table(), this.tableId, generation);
        return new FlushWriter(){

            @Override
            public void append(PaxosKeyState commitState) throws IOException {
                if (commitState.committed) {
                    return;
                }
                writer.append(commitState);
            }

            @Override
            public void finish() {
                UncommittedTableData.this.rebuildComplete(writer.finish());
            }

            @Override
            public Throwable abort(Throwable accumulate) {
                accumulate = writer.abort(accumulate);
                logger.info("paxos rebuild aborted for {}.{}", (Object)UncommittedTableData.this.keyspace(), (Object)UncommittedTableData.this.table());
                UncommittedTableData.this.rebuilding = false;
                return accumulate;
            }
        };
    }

    synchronized void maybeScheduleMerge() {
        logger.info("Scheduling uncommitted paxos data merge task for {}.{}", (Object)this.keyspace(), (Object)this.table());
        if (this.data.files.size() < 2 || this.merge != null) {
            return;
        }
        this.createMergeTask().maybeSchedule();
    }

    @VisibleForTesting
    synchronized Merge createMergeTask() {
        Preconditions.checkState(this.merge == null);
        this.merge = new Merge(this.nextGeneration++);
        return this.merge;
    }

    synchronized boolean hasInProgressIO() {
        return this.merge != null || !this.activeFlushes.isEmpty();
    }

    void truncate() {
        logger.info("truncating uncommitting paxos date for {}.{}", (Object)this.keyspace(), (Object)this.table());
        this.data.truncate();
        this.data = new Data(ImmutableSet.of());
    }

    @VisibleForTesting
    Data data() {
        return this.data;
    }

    @VisibleForTesting
    long nextGeneration() {
        return this.nextGeneration;
    }

    @VisibleForTesting
    Merge currentMerge() {
        return this.merge;
    }

    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownAndWait(timeout, units, executor);
    }

    static {
        Token min2 = DatabaseDescriptor.getPartitioner().getMinimumToken();
        FULL_RANGE = Collections.singleton(new Range<Token>(min2, min2));
        UNKNOWN_TABLE = TableMetadata.minimal("UNKNOWN", "UNKNOWN");
        executor = ExecutorFactory.Global.executorFactory().sequential("PaxosUncommittedMerge");
    }

    class Merge
    implements Runnable {
        final int generation;
        boolean isScheduled = false;

        Merge(int generation) {
            this.generation = generation;
        }

        @Override
        public void run() {
            try {
                Preconditions.checkState(!this.dependsOnActiveFlushes());
                Data current = UncommittedTableData.this.data;
                SchemaElement name = UncommittedTableData.tableName(UncommittedTableData.this.tableId);
                UncommittedDataFile.Writer writer = UncommittedDataFile.writer(UncommittedTableData.this.directory, name.elementKeyspace(), name.elementName(), UncommittedTableData.this.tableId, this.generation);
                HashSet<UncommittedDataFile> files = Sets.newHashSet(Iterables.filter(current.files, u -> u.generation() < (long)this.generation));
                logger.info("merging {} paxos uncommitted files into a new generation {} file for {}.{}", new Object[]{files.size(), this.generation, UncommittedTableData.this.keyspace(), UncommittedTableData.this.table()});
                try (CloseableIterator<PaxosKeyState> iterator = UncommittedTableData.this.filterFactory.filter(UncommittedTableData.merge(files, FULL_RANGE));){
                    while (iterator.hasNext()) {
                        PaxosKeyState next = (PaxosKeyState)iterator.next();
                        if (next.committed) continue;
                        writer.append(next);
                    }
                    UncommittedTableData.this.mergeComplete(this, writer.finish());
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        void maybeSchedule() {
            if (this.isScheduled) {
                return;
            }
            if (this.dependsOnActiveFlushes()) {
                return;
            }
            executor.submit(UncommittedTableData.this.merge);
            UncommittedTableData.this.merge.isScheduled = true;
        }

        boolean dependsOnActiveFlushes() {
            return !UncommittedTableData.this.activeFlushes.headSet(this.generation).isEmpty();
        }
    }

    private static class Reducer
    extends MergeIterator.Reducer<PaxosKeyState, PaxosKeyState> {
        PaxosKeyState merged = null;

        private Reducer() {
        }

        @Override
        public void reduce(int idx, PaxosKeyState current) {
            this.merged = PaxosKeyState.merge(this.merged, current);
        }

        @Override
        protected PaxosKeyState getReduced() {
            return this.merged;
        }

        @Override
        protected void onKeyChange() {
            this.merged = null;
        }
    }

    static class Data {
        final ImmutableSet<UncommittedDataFile> files;

        Data(ImmutableSet<UncommittedDataFile> files) {
            this.files = files;
        }

        Data withFile(UncommittedDataFile file) {
            return new Data((ImmutableSet<UncommittedDataFile>)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.files)).add(file)).build());
        }

        void truncate() {
            for (UncommittedDataFile file : this.files) {
                file.markDeleted();
            }
        }
    }

    private static class CFSFilterFactory
    extends FilterFactory {
        private final TableId tableId;

        CFSFilterFactory(TableId tableId) {
            this.tableId = tableId;
        }

        @Override
        List<Range<Token>> getReplicatedRanges() {
            if (this.tableId == null) {
                return Range.normalize(FULL_RANGE);
            }
            ColumnFamilyStore table = Schema.instance.getColumnFamilyStoreInstance(this.tableId);
            if (table == null) {
                return Range.normalize(FULL_RANGE);
            }
            String ksName = table.getKeyspaceName();
            List ranges = StorageService.instance.getLocalAndPendingRanges(ksName);
            if (ranges.isEmpty()) {
                return Range.normalize(FULL_RANGE);
            }
            return Range.normalize(ranges);
        }

        @Override
        PaxosRepairHistory getPaxosRepairHistory() {
            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(this.tableId);
            if (cfs == null) {
                return PaxosRepairHistory.EMPTY;
            }
            return cfs.getPaxosRepairHistory();
        }
    }

    static abstract class FilterFactory {
        FilterFactory() {
        }

        abstract List<Range<Token>> getReplicatedRanges();

        abstract PaxosRepairHistory getPaxosRepairHistory();

        CloseableIterator<PaxosKeyState> filter(CloseableIterator<PaxosKeyState> iterator) {
            return new FilteringIterator(iterator, this.getReplicatedRanges(), this.getPaxosRepairHistory());
        }
    }

    private static class FilteringIterator
    extends AbstractIterator<PaxosKeyState>
    implements CloseableIterator<PaxosKeyState> {
        private final CloseableIterator<PaxosKeyState> wrapped;
        private final PeekingIterator<PaxosKeyState> peeking;
        private final PeekingIterator<Range<Token>> rangeIterator;
        private final PaxosRepairHistory.Searcher historySearcher;

        FilteringIterator(CloseableIterator<PaxosKeyState> wrapped, List<Range<Token>> ranges, PaxosRepairHistory history) {
            this.wrapped = wrapped;
            this.peeking = Iterators.peekingIterator(wrapped);
            this.rangeIterator = Iterators.peekingIterator(Range.normalize(ranges).iterator());
            this.historySearcher = history.searcher();
        }

        @Override
        protected PaxosKeyState computeNext() {
            PaxosKeyState next;
            while (true) {
                Token token;
                if (!this.peeking.hasNext() || !this.rangeIterator.hasNext()) {
                    return (PaxosKeyState)this.endOfData();
                }
                Range<Token> range = this.rangeIterator.peek();
                if (!range.contains(token = this.peeking.peek().key.getToken())) {
                    if (((Token)range.right).compareTo(token) < 0) {
                        this.rangeIterator.next();
                        continue;
                    }
                    this.peeking.next();
                    continue;
                }
                next = this.peeking.next();
                Ballot lowBound = this.historySearcher.ballotForToken(token);
                if (!Commit.isAfter(lowBound, next.ballot)) break;
            }
            return next;
        }

        @Override
        public void close() {
            this.wrapped.close();
        }
    }

    public static interface FlushWriter {
        public void append(PaxosKeyState var1) throws IOException;

        public void finish();

        public Throwable abort(Throwable var1);

        default public void appendAll(Iterable<PaxosKeyState> states) throws IOException {
            for (PaxosKeyState state : states) {
                this.append(state);
            }
        }
    }
}

