/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupException;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupHistory;
import org.apache.cassandra.utils.concurrent.AsyncFuture;

public class PaxosFinishPrepareCleanup
extends AsyncFuture<Void>
implements RequestCallbackWithFailure<Void> {
    private final Set<InetAddressAndPort> waitingResponse;
    public static final IVerbHandler<PaxosCleanupHistory> verbHandler = PaxosFinishPrepareCleanup.createVerbHandler(SharedContext.Global.instance);

    PaxosFinishPrepareCleanup(Collection<InetAddressAndPort> endpoints) {
        this.waitingResponse = new HashSet<InetAddressAndPort>(endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PaxosFinishPrepareCleanup finish(SharedContext ctx, Collection<InetAddressAndPort> endpoints, PaxosCleanupHistory result) {
        PaxosFinishPrepareCleanup callback;
        PaxosFinishPrepareCleanup paxosFinishPrepareCleanup = callback = new PaxosFinishPrepareCleanup(endpoints);
        synchronized (paxosFinishPrepareCleanup) {
            Message<PaxosCleanupHistory> message = Message.out(Verb.PAXOS2_CLEANUP_FINISH_PREPARE_REQ, result);
            for (InetAddressAndPort endpoint : endpoints) {
                ctx.messaging().sendWithCallback(message, endpoint, callback);
            }
        }
        return callback;
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.tryFailure(new PaxosCleanupException(reason + " failure response from " + from));
    }

    @Override
    public synchronized void onResponse(Message<Void> msg) {
        if (this.isDone()) {
            return;
        }
        if (!this.waitingResponse.remove(msg.from())) {
            throw new IllegalArgumentException("Received unexpected response from " + msg.from());
        }
        if (this.waitingResponse.isEmpty()) {
            this.trySuccess(null);
        }
    }

    public static IVerbHandler<PaxosCleanupHistory> createVerbHandler(SharedContext ctx) {
        return ctx.paxosRepairState()::addCleanupHistory;
    }
}

