/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaxosRepair {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPaxosRepair.class);
    public static final Result DONE = new Result(Result.Outcome.DONE);
    public static final Result CANCELLED = new Result(Result.Outcome.CANCELLED);
    private final DecoratedKey partitionKey;
    private final Ballot incompleteBallot;
    private List<Listener> listeners = null;
    private volatile State state;
    private volatile long startedNanos = Long.MIN_VALUE;

    static boolean isResult(State state) {
        return state instanceof Result;
    }

    public AbstractPaxosRepair(DecoratedKey partitionKey, Ballot incompleteBallot) {
        this.partitionKey = partitionKey;
        this.incompleteBallot = incompleteBallot;
    }

    public State state() {
        return this.state;
    }

    public long startedNanos() {
        return this.startedNanos;
    }

    public boolean isStarted() {
        return this.startedNanos != Long.MIN_VALUE;
    }

    public boolean isComplete() {
        return AbstractPaxosRepair.isResult(this.state);
    }

    public Ballot incompleteBallot() {
        return this.incompleteBallot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPaxosRepair addListener(Listener listener) {
        Result result = null;
        AbstractPaxosRepair abstractPaxosRepair = this;
        synchronized (abstractPaxosRepair) {
            if (AbstractPaxosRepair.isResult(this.state)) {
                result = (Result)this.state;
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<Listener>();
                }
                this.listeners.add(listener);
            }
        }
        if (result != null) {
            listener.onComplete(this, result);
        }
        return this;
    }

    public AbstractPaxosRepair addListener(Consumer<Result> listener) {
        return this.addListener((AbstractPaxosRepair repair, Result result) -> listener.accept(result));
    }

    public final DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    public State restart(State state) {
        return this.restart(state, Long.MIN_VALUE);
    }

    public abstract State restart(State var1, long var2);

    public final synchronized AbstractPaxosRepair start() {
        this.updateState(null, null, (state, i2) -> {
            Preconditions.checkState(!this.isStarted());
            this.startedNanos = Math.max(-9223372036854775807L, Clock.Global.nanoTime());
            return this.restart((State)state);
        });
        return this;
    }

    public final void cancel() {
        this.set(CANCELLED);
    }

    public final void cancelUnexceptionally() {
        try {
            this.cancel();
        }
        catch (Throwable t2) {
            logger.error("Exception cancelling paxos repair", t2);
        }
    }

    public final synchronized Result await() throws InterruptedException {
        while (!AbstractPaxosRepair.isResult(this.state)) {
            this.wait();
        }
        return (Result)this.state;
    }

    protected void set(Result result) {
        this.updateState(this.state(), null, (i1, i2) -> result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S extends State, I, T extends Throwable> void updateState(S expect, I param, StateUpdater<S, I, T> transform) {
        Result result = null;
        List<Listener> listeners = null;
        AbstractPaxosRepair abstractPaxosRepair = this;
        synchronized (abstractPaxosRepair) {
            State next;
            try {
                if (this.state != expect) {
                    return;
                }
                next = transform.apply(expect, param);
                this.state = next;
            }
            catch (Throwable t2) {
                next = new Failure(t2);
                this.state = next;
            }
            if (AbstractPaxosRepair.isResult(next)) {
                this.notifyAll();
                result = next;
                listeners = this.listeners;
                this.listeners = null;
            }
        }
        if (result != null && listeners != null) {
            Throwable t3 = null;
            int mi = listeners.size();
            for (int i = 0; i < mi; ++i) {
                try {
                    listeners.get(i).onComplete(this, result);
                    continue;
                }
                catch (Throwable throwable) {
                    t3 = Throwables.merge(t3, throwable);
                }
            }
            Throwables.maybeFail(t3);
        }
    }

    public static final class Failure
    extends Result {
        public final Throwable failure;

        Failure(Throwable failure) {
            super(Result.Outcome.FAILURE);
            this.failure = failure;
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (this.failure != null) {
                this.failure.printStackTrace(pw);
            }
            return this.outcome.toString() + ": " + sw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure1 = (Failure)o;
            return Objects.equals(this.failure, failure1.failure);
        }

        public int hashCode() {
            return Objects.hash(this.failure);
        }
    }

    public static class Result
    extends State {
        final Outcome outcome;

        public Result(Outcome outcome) {
            this.outcome = outcome;
        }

        public String toString() {
            return this.outcome.toString();
        }

        public boolean wasSuccessful() {
            return this.outcome == Outcome.DONE;
        }

        static enum Outcome {
            DONE,
            CANCELLED,
            FAILURE;

        }
    }

    abstract class ConsumerState<T>
    extends State
    implements Consumer<T> {
        ConsumerState() {
        }

        @Override
        public void accept(T input) {
            AbstractPaxosRepair.this.updateState(this, input, ConsumerState::execute);
        }

        abstract State execute(T var1) throws Throwable;
    }

    public static interface Listener {
        public void onComplete(AbstractPaxosRepair var1, Result var2);
    }

    public static interface StateUpdater<S, I, T extends Throwable> {
        public State apply(S var1, I var2) throws T;
    }

    public static class State {
    }
}

