/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.ReflectPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.security.SecurityThreadGroup;
import org.apache.cassandra.utils.logging.LoggingSupportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadAwareSecurityManager
extends SecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(ThreadAwareSecurityManager.class);
    public static final PermissionCollection noPermissions = new PermissionCollection(){

        @Override
        public void add(Permission permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.emptyEnumeration();
        }
    };
    private static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");
    private static final RuntimePermission MODIFY_THREAD_PERMISSION = new RuntimePermission("modifyThread");
    private static final RuntimePermission MODIFY_THREADGROUP_PERMISSION = new RuntimePermission("modifyThreadGroup");
    private static final RuntimePermission SET_SECURITY_MANAGER_PERMISSION = new RuntimePermission("setSecurityManager");
    private static final RuntimePermission NASHORN_GLOBAL_PERMISSION = new RuntimePermission("nashorn.createGlobal");
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    private static final RuntimePermission DYNALINK_LOOKUP_PERMISSION = new RuntimePermission("dynalink.getLookup");
    private static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static volatile boolean installed;
    private static final FastThreadLocal<Boolean> initializedThread;

    public static void install() {
        if (installed) {
            return;
        }
        logger.trace("Initialized thread aware security manager", (Object)AccessControlException.class.getName());
        System.setSecurityManager(new ThreadAwareSecurityManager());
        LoggingSupportFactory.getLoggingSupport().onStartup();
        installed = true;
    }

    private ThreadAwareSecurityManager() {
    }

    public static boolean isSecuredThread() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (!(tg instanceof SecurityThreadGroup)) {
            return false;
        }
        Boolean threadInitialized = initializedThread.get();
        if (threadInitialized == null) {
            initializedThread.set(false);
            ((SecurityThreadGroup)tg).initializeThread();
            initializedThread.set(true);
            threadInitialized = true;
        }
        return threadInitialized;
    }

    @Override
    public void checkAccess(Thread t2) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + MODIFY_THREAD_PERMISSION, MODIFY_THREAD_PERMISSION);
        }
        super.checkAccess(t2);
    }

    @Override
    public void checkAccess(ThreadGroup g2) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + MODIFY_THREADGROUP_PERMISSION, MODIFY_THREADGROUP_PERMISSION);
        }
        super.checkAccess(g2);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (!DatabaseDescriptor.enableUserDefinedFunctionsThreads() && !DatabaseDescriptor.allowExtraInsecureUDFs() && SET_SECURITY_MANAGER_PERMISSION.equals(perm)) {
            throw new AccessControlException("Access denied");
        }
        if (!ThreadAwareSecurityManager.isSecuredThread()) {
            return;
        }
        if (CHECK_MEMBER_ACCESS_PERMISSION.equals(perm)) {
            return;
        }
        if (NASHORN_GLOBAL_PERMISSION.equals(perm)) {
            return;
        }
        if (SUPPRESS_ACCESS_CHECKS_PERMISSION.equals(perm)) {
            return;
        }
        if (DYNALINK_LOOKUP_PERMISSION.equals(perm)) {
            return;
        }
        if (GET_CLASSLOADER_PERMISSION.equals(perm)) {
            return;
        }
        super.checkPermission(perm);
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            super.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (!ThreadAwareSecurityManager.isSecuredThread()) {
            return;
        }
        if (!((SecurityThreadGroup)Thread.currentThread().getThreadGroup()).isPackageAllowed(pkg)) {
            RuntimePermission perm = new RuntimePermission("accessClassInPackage." + pkg);
            throw new AccessControlException("access denied: " + perm, perm);
        }
    }

    static {
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                if (codesource == null || codesource.getLocation() == null) {
                    return perms;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "jar": {
                        if (!codesource.getLocation().getPath().startsWith("file:")) {
                            return perms;
                        }
                    }
                    case "file": {
                        perms.add(new AllPermission());
                        return perms;
                    }
                }
                return perms;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                return this.getPermissions(domain.getCodeSource());
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                CodeSource codesource = domain.getCodeSource();
                if (codesource == null || codesource.getLocation() == null) {
                    return false;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "jar": {
                        return codesource.getLocation().getPath().startsWith("file:");
                    }
                    case "file": {
                        return true;
                    }
                }
                return false;
            }
        });
        initializedThread = new FastThreadLocal();
    }
}

