/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import javax.annotation.Nullable;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.CustomParamsSerializer;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Int32Serializer;
import org.apache.cassandra.utils.Int64Serializer;
import org.apache.cassandra.utils.RangesSerializer;
import org.apache.cassandra.utils.TimeUUID;

public enum ParamType {
    FORWARD_TO(0, ForwardingInfo.serializer),
    RESPOND_TO(1, InetAddressAndPort.FwdFrmSerializer.fwdFrmSerializer),
    TRACE_SESSION(5, TimeUUID.Serializer.instance),
    TRACE_TYPE(6, Tracing.traceTypeSerializer),
    TOMBSTONE_FAIL(8, Int32Serializer.serializer),
    TOMBSTONE_WARNING(9, Int32Serializer.serializer),
    LOCAL_READ_SIZE_FAIL(10, Int64Serializer.serializer),
    LOCAL_READ_SIZE_WARN(11, Int64Serializer.serializer),
    ROW_INDEX_READ_SIZE_FAIL(12, Int64Serializer.serializer),
    ROW_INDEX_READ_SIZE_WARN(13, Int64Serializer.serializer),
    CUSTOM_MAP(14, CustomParamsSerializer.serializer),
    SNAPSHOT_RANGES(15, RangesSerializer.serializer),
    TOO_MANY_REFERENCED_INDEXES_WARN(16, Int32Serializer.serializer),
    TOO_MANY_REFERENCED_INDEXES_FAIL(17, Int32Serializer.serializer);

    final int id;
    final IVersionedSerializer serializer;
    private static final ParamType[] idToTypeMap;

    private ParamType(int id, IVersionedSerializer serializer) {
        if (id < 0) {
            throw new IllegalArgumentException("ParamType id must be non-negative");
        }
        this.id = id;
        this.serializer = serializer;
    }

    @Nullable
    static ParamType lookUpById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("ParamType id must be non-negative (got " + id + ")");
        }
        return id < idToTypeMap.length ? idToTypeMap[id] : null;
    }

    static {
        ParamType[] types = ParamType.values();
        int max = -1;
        for (ParamType t2 : types) {
            max = Math.max(t2.id, max);
        }
        ParamType[] idMap = new ParamType[max + 1];
        for (ParamType type : types) {
            if (idMap[type.id] != null) {
                throw new RuntimeException("Two ParamType-s that map to the same id: " + type.id);
            }
            idMap[type.id] = type;
        }
        idToTypeMap = idMap;
    }
}

