/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.net.AsyncChannelOutputPlus;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.SharedDefaultFileRegion;
import org.apache.cassandra.streaming.StreamingDataOutputPlus;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStreamingOutputPlus
extends AsyncChannelOutputPlus
implements StreamingDataOutputPlus {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStreamingOutputPlus.class);
    private final BufferPool bufferPool = BufferPools.forNetworking();
    final int defaultLowWaterMark;
    final int defaultHighWaterMark;

    public AsyncStreamingOutputPlus(Channel channel) {
        super(channel);
        WriteBufferWaterMark waterMark = channel.config().getWriteBufferWaterMark();
        this.defaultLowWaterMark = waterMark.low();
        this.defaultHighWaterMark = waterMark.high();
        this.allocateBuffer();
    }

    private void allocateBuffer() {
        this.buffer = this.bufferPool.getAtLeast(8192, BufferType.OFF_HEAP);
    }

    @Override
    protected void doFlush(int count) throws IOException {
        if (!this.channel.isOpen()) {
            throw new ClosedChannelException();
        }
        ByteBuffer flush = this.buffer;
        if (flush.position() == 0) {
            return;
        }
        flush.flip();
        int byteCount = flush.limit();
        ChannelPromise promise = this.beginFlush(byteCount, 0L, Integer.MAX_VALUE);
        this.channel.writeAndFlush(GlobalBufferPoolAllocator.wrap(flush), promise);
        this.allocateBuffer();
    }

    @Override
    public long position() {
        return this.flushed() + (long)this.buffer.position();
    }

    @Override
    public int writeToChannel(StreamingDataOutputPlus.Write write, StreamingDataOutputPlus.RateLimiter limiter) throws IOException {
        this.doFlush(0);
        class Holder {
            ChannelPromise promise;
            ByteBuffer buffer;

            Holder() {
            }
        }
        Holder holder = new Holder();
        try {
            write.write((int size) -> {
                if (holder.buffer != null) {
                    throw new IllegalStateException("Can only allocate one ByteBuffer");
                }
                limiter.acquire(size);
                holder.promise = this.beginFlush(size, this.defaultLowWaterMark, this.defaultHighWaterMark);
                holder.buffer = this.bufferPool.get(size, BufferType.OFF_HEAP);
                return holder.buffer;
            });
        }
        catch (Throwable t2) {
            if (holder.buffer != null) {
                this.bufferPool.put(holder.buffer);
            }
            if (holder.promise != null) {
                holder.promise.tryFailure(t2);
            }
            throw t2;
        }
        ByteBuffer buffer = holder.buffer;
        this.bufferPool.putUnusedPortion(buffer);
        int length = buffer.limit();
        this.channel.writeAndFlush(GlobalBufferPoolAllocator.wrap(buffer), holder.promise);
        return length;
    }

    @Override
    public long writeFileToChannel(FileChannel file, StreamingDataOutputPlus.RateLimiter limiter) throws IOException {
        if (this.channel.pipeline().get(SslHandler.class) != null) {
            return this.writeFileToChannel(file, limiter, 65536);
        }
        return this.writeFileToChannelZeroCopy(file, limiter, 0x100000, 0x100000, 0x200000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long writeFileToChannel(FileChannel fc, StreamingDataOutputPlus.RateLimiter limiter, int batchSize) throws IOException {
        long bytesTransferred;
        long length = fc.size();
        try {
            int toWrite;
            for (bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += (long)toWrite) {
                toWrite = (int)Math.min((long)batchSize, length - bytesTransferred);
                long position = bytesTransferred;
                this.writeToChannel(bufferSupplier -> {
                    ByteBuffer outBuffer = bufferSupplier.get(toWrite);
                    long read = fc.read(outBuffer, position);
                    if (read != (long)toWrite) {
                        throw new IOException(String.format("could not read required number of bytes from file to be streamed: read %d bytes, wanted %d bytes", read, toWrite));
                    }
                    outBuffer.flip();
                }, limiter);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Writing {} bytes at position {} of {}", new Object[]{toWrite, bytesTransferred, length});
            }
        }
        finally {
            fc.close();
        }
        return bytesTransferred;
    }

    @VisibleForTesting
    long writeFileToChannelZeroCopy(FileChannel file, StreamingDataOutputPlus.RateLimiter limiter, int batchSize, int lowWaterMark, int highWaterMark) throws IOException {
        if (!limiter.isRateLimited()) {
            return this.writeFileToChannelZeroCopyUnthrottled(file);
        }
        return this.writeFileToChannelZeroCopyThrottled(file, limiter, batchSize, lowWaterMark, highWaterMark);
    }

    private long writeFileToChannelZeroCopyUnthrottled(FileChannel file) throws IOException {
        long length = file.size();
        if (logger.isTraceEnabled()) {
            logger.trace("Writing {} bytes", (Object)length);
        }
        ChannelPromise promise = this.beginFlush(length, 0L, length);
        DefaultFileRegion defaultFileRegion = new DefaultFileRegion(file, 0L, length);
        this.channel.writeAndFlush(defaultFileRegion, promise);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeFileToChannelZeroCopyThrottled(FileChannel file, StreamingDataOutputPlus.RateLimiter limiter, int batchSize, int lowWaterMark, int highWaterMark) throws IOException {
        long length = file.size();
        SharedDefaultFileRegion.SharedFileChannel sharedFile = SharedDefaultFileRegion.share(file);
        try {
            long bytesTransferred;
            int toWrite;
            for (bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += (long)toWrite) {
                toWrite = (int)Math.min((long)batchSize, length - bytesTransferred);
                limiter.acquire(toWrite);
                ChannelPromise promise = this.beginFlush(toWrite, lowWaterMark, highWaterMark);
                SharedDefaultFileRegion fileRegion = new SharedDefaultFileRegion(sharedFile, bytesTransferred, (long)toWrite);
                this.channel.writeAndFlush(fileRegion, promise);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Writing {} bytes at position {} of {}", new Object[]{toWrite, bytesTransferred, length});
            }
            long l = bytesTransferred;
            return l;
        }
        finally {
            sharedFile.release();
        }
    }

    @Override
    public void discard() {
        if (this.buffer != null) {
            this.bufferPool.put(this.buffer);
            this.buffer = null;
        }
    }
}

