/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.clearspring.analytics.stream.StreamSummary;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.metrics.Sampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FrequencySampler<T>
extends Sampler<T> {
    private static final Logger logger = LoggerFactory.getLogger(FrequencySampler.class);
    private StreamSummary<T> summary;

    @Override
    public synchronized void beginSampling(int capacity, long durationMillis) {
        if (this.isActive()) {
            throw new RuntimeException("Sampling already in progress");
        }
        this.updateEndTime(this.clock.now() + TimeUnit.MILLISECONDS.toNanos(durationMillis));
        this.summary = new StreamSummary(capacity);
    }

    @Override
    public synchronized List<Sampler.Sample<T>> finishSampling(int count) {
        List<Sampler.Sample<T>> results = Collections.emptyList();
        if (this.isEnabled()) {
            this.disable();
            results = this.summary.topK(count).stream().map(c -> new Sampler.Sample(c.getItem(), c.getCount(), c.getError())).collect(Collectors.toList());
        }
        return results;
    }

    @Override
    protected synchronized void insert(T item, long value) {
        if (value > 0L && this.isActive()) {
            try {
                this.summary.offer(item, (int)Math.min(value, Integer.MAX_VALUE));
            }
            catch (Exception e) {
                logger.trace("Failure to offer sample", (Throwable)e);
            }
        }
    }
}

