/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChecksummedRebufferer;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ChecksumType;

public final class ChecksummedRandomAccessReader {
    public static RandomAccessReader open(File file, File crcFile) throws IOException {
        ChannelProxy channel = new ChannelProxy(file);
        try {
            DataIntegrityMetadata.ChecksumValidator validator = new DataIntegrityMetadata.ChecksumValidator(ChecksumType.CRC32, RandomAccessReader.open(crcFile), file.path());
            ChecksummedRebufferer rebufferer = new ChecksummedRebufferer(channel, validator);
            return new RandomAccessReader.RandomAccessReaderWithOwnChannel(rebufferer);
        }
        catch (Throwable t2) {
            channel.close();
            throw t2;
        }
    }
}

