/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.KeyReader;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.CompressionInfoComponent;
import org.apache.cassandra.io.sstable.format.FilterComponent;
import org.apache.cassandra.io.sstable.format.SortedTableReaderLoadingBuilder;
import org.apache.cassandra.io.sstable.format.StatsComponent;
import org.apache.cassandra.io.sstable.format.bti.BtiFormat;
import org.apache.cassandra.io.sstable.format.bti.BtiTableReader;
import org.apache.cassandra.io.sstable.format.bti.PartitionIndex;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BtiTableReaderLoadingBuilder
extends SortedTableReaderLoadingBuilder<BtiTableReader, BtiTableReader.Builder> {
    private static final Logger logger = LoggerFactory.getLogger(BtiTableReaderLoadingBuilder.class);
    private FileHandle.Builder partitionIndexFileBuilder;
    private FileHandle.Builder rowIndexFileBuilder;

    public BtiTableReaderLoadingBuilder(SSTable.Builder<?, ?> builder) {
        super(builder);
    }

    @Override
    public KeyReader buildKeyReader(TableMetrics tableMetrics) throws IOException {
        StatsComponent statsComponent = StatsComponent.load(this.descriptor, MetadataType.STATS, MetadataType.HEADER, MetadataType.VALIDATION);
        return this.createKeyReader(statsComponent.statsMetadata());
    }

    /*
     * Exception decompiling
     */
    private KeyReader createKeyReader(StatsMetadata statsMetadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void openComponents(BtiTableReader.Builder builder, SSTable.Owner owner, boolean validate, boolean online) throws IOException {
        try {
            boolean rebuildFilter;
            StatsComponent statsComponent = StatsComponent.load(this.descriptor, MetadataType.STATS, MetadataType.VALIDATION, MetadataType.HEADER);
            builder.setSerializationHeader(statsComponent.serializationHeader(builder.getTableMetadataRef().getLocal()));
            Preconditions.checkArgument(!online || builder.getSerializationHeader() != null);
            builder.setStatsMetadata(statsComponent.statsMetadata());
            ValidationMetadata validationMetadata = statsComponent.validationMetadata();
            this.validatePartitioner(builder.getTableMetadataRef().getLocal(), validationMetadata);
            boolean filterNeeded = online;
            if (filterNeeded) {
                builder.setFilter(this.loadFilter(validationMetadata));
            }
            boolean bl = rebuildFilter = filterNeeded && builder.getFilter() == null;
            if (builder.getComponents().contains(BtiFormat.Components.PARTITION_INDEX) && builder.getComponents().contains(BtiFormat.Components.ROW_INDEX) && rebuildFilter) {
                IFilter filter = this.buildBloomFilter(statsComponent.statsMetadata());
                builder.setFilter(filter);
                FilterComponent.save(filter, this.descriptor, false);
            }
            if (builder.getFilter() == null) {
                builder.setFilter(FilterFactory.AlwaysPresent);
            }
            if (builder.getComponents().contains(BtiFormat.Components.ROW_INDEX)) {
                builder.setRowIndexFile(this.rowIndexFileBuilder().complete());
            }
            if (this.descriptor.version.hasKeyRange() && builder.getStatsMetadata() != null) {
                IPartitioner partitioner = this.tableMetadataRef.getLocal().partitioner;
                builder.setFirst(partitioner.decorateKey(builder.getStatsMetadata().firstKey));
                builder.setLast(partitioner.decorateKey(builder.getStatsMetadata().lastKey));
            }
            if (builder.getComponents().contains(BtiFormat.Components.PARTITION_INDEX)) {
                builder.setPartitionIndex(this.openPartitionIndex(!builder.getFilter().isInformative()));
                if (builder.getFirst() == null || builder.getLast() == null) {
                    builder.setFirst(builder.getPartitionIndex().firstKey());
                    builder.setLast(builder.getPartitionIndex().lastKey());
                }
            }
            try (CompressionMetadata compressionMetadata = CompressionInfoComponent.maybeLoad(this.descriptor, this.components);){
                builder.setDataFile(this.dataFileBuilder(builder.getStatsMetadata()).withCompressionMetadata(compressionMetadata).withCrcCheckChance(() -> this.tableMetadataRef.getLocal().params.crcCheckChance).complete());
            }
        }
        catch (IOException | Error | RuntimeException ex) {
            Throwables.closeAndAddSuppressed(ex, builder.getPartitionIndex(), builder.getRowIndexFile(), builder.getDataFile(), builder.getFilter());
            throw ex;
        }
    }

    private IFilter buildBloomFilter(StatsMetadata statsMetadata) throws IOException {
        IFilter bf = null;
        try (KeyReader keyReader = this.createKeyReader(statsMetadata);){
            bf = FilterFactory.getFilter(statsMetadata.totalRows, this.tableMetadataRef.getLocal().params.bloomFilterFpChance);
            while (!keyReader.isExhausted()) {
                DecoratedKey key = this.tableMetadataRef.getLocal().partitioner.decorateKey(keyReader.key());
                bf.add(key);
                keyReader.advance();
            }
        }
        catch (IOException | Error | RuntimeException ex) {
            Throwables.closeAndAddSuppressed(ex, bf);
            throw ex;
        }
        return bf;
    }

    private PartitionIndex openPartitionIndex(boolean preload) throws IOException {
        PartitionIndex partitionIndex;
        block8: {
            FileHandle indexFile = this.partitionIndexFileBuilder().complete();
            try {
                partitionIndex = PartitionIndex.load(indexFile, this.tableMetadataRef.getLocal().partitioner, preload);
                if (indexFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (indexFile != null) {
                        try {
                            indexFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    logger.debug("Partition index file is corrupted: " + this.descriptor.fileFor(BtiFormat.Components.PARTITION_INDEX), (Throwable)ex);
                    throw ex;
                }
            }
            indexFile.close();
        }
        return partitionIndex;
    }

    private FileHandle.Builder rowIndexFileBuilder() {
        assert (this.rowIndexFileBuilder == null || this.rowIndexFileBuilder.file.equals(this.descriptor.fileFor(BtiFormat.Components.ROW_INDEX)));
        if (this.rowIndexFileBuilder == null) {
            this.rowIndexFileBuilder = new FileHandle.Builder(this.descriptor.fileFor(BtiFormat.Components.ROW_INDEX));
        }
        this.rowIndexFileBuilder.withChunkCache(this.chunkCache);
        this.rowIndexFileBuilder.mmapped(this.ioOptions.indexDiskAccessMode);
        return this.rowIndexFileBuilder;
    }

    private FileHandle.Builder partitionIndexFileBuilder() {
        assert (this.partitionIndexFileBuilder == null || this.partitionIndexFileBuilder.file.equals(this.descriptor.fileFor(BtiFormat.Components.PARTITION_INDEX)));
        if (this.partitionIndexFileBuilder == null) {
            this.partitionIndexFileBuilder = new FileHandle.Builder(this.descriptor.fileFor(BtiFormat.Components.PARTITION_INDEX));
        }
        this.partitionIndexFileBuilder.withChunkCache(this.chunkCache);
        this.partitionIndexFileBuilder.mmapped(this.ioOptions.indexDiskAccessMode);
        return this.partitionIndexFileBuilder;
    }

    private /* synthetic */ Double lambda$createKeyReader$0() {
        return this.tableMetadataRef.getLocal().params.crcCheckChance;
    }
}

