/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.guardrails.Threshold;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.PartitionSerializationException;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.FilterComponent;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.SortedTablePartitionWriter;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortedTableWriter<P extends SortedTablePartitionWriter, I extends AbstractIndexWriter>
extends SSTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(SortedTableWriter.class);
    protected final SequentialWriter dataWriter;
    protected final I indexWriter;
    protected final P partitionWriter;
    private final FileHandle.Builder dataFileBuilder;
    private DecoratedKey lastWrittenKey;
    private DataPosition dataMark;
    private long lastEarlyOpenLength;
    private final Supplier<Double> crcCheckChanceSupplier;

    public SortedTableWriter(Builder<P, I, ?, ?> builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, lifecycleNewTracker, owner);
        this.dataFileBuilder = new FileHandle.Builder(this.descriptor.fileFor(SSTableFormat.Components.DATA));
        TableMetadataRef ref = builder.getTableMetadataRef();
        this.crcCheckChanceSupplier = () -> ref.getLocal().params.crcCheckChance;
        SequentialWriter dataWriter = null;
        Object indexWriter = null;
        Object partitionWriter = null;
        try {
            dataWriter = builder.openDataWriter();
            Preconditions.checkNotNull(dataWriter);
            indexWriter = builder.openIndexWriter(dataWriter);
            Preconditions.checkNotNull(indexWriter);
            partitionWriter = builder.openPartitionWriter(dataWriter, indexWriter);
            Preconditions.checkNotNull(partitionWriter);
            this.dataWriter = dataWriter;
            this.indexWriter = indexWriter;
            this.partitionWriter = partitionWriter;
        }
        catch (Error | RuntimeException ex) {
            Throwables.closeNonNullAndAddSuppressed(ex, new AutoCloseable[]{partitionWriter, indexWriter, dataWriter});
            this.handleConstructionFailure(ex);
            throw ex;
        }
    }

    @Override
    public final AbstractRowIndexEntry append(UnfilteredRowIterator partition) {
        if (partition.isEmpty()) {
            return null;
        }
        try {
            if (!this.verifyPartition(partition.partitionKey())) {
                return null;
            }
            this.startPartition(partition.partitionKey(), partition.partitionLevelDeletion());
            if (this.header.hasStatic()) {
                this.addStaticRow(partition.partitionKey(), partition.staticRow());
            }
            while (partition.hasNext()) {
                this.addUnfiltered(partition.partitionKey(), (Unfiltered)partition.next());
            }
            AbstractRowIndexEntry indexEntry = this.endPartition(partition.partitionKey(), partition.partitionLevelDeletion());
            return indexEntry;
        }
        catch (BufferOverflowException boe) {
            throw new PartitionSerializationException(partition, (Throwable)boe);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getFilename());
        }
    }

    private boolean verifyPartition(DecoratedKey key) {
        assert (key != null) : "Keys must not be null";
        if (key.getKey().remaining() > 65535) {
            logger.error("Key size {} exceeds maximum of {}, skipping row", (Object)key.getKey().remaining(), (Object)65535);
            return false;
        }
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(key) >= 0) {
            throw new RuntimeException(String.format("Last written key %s >= current key %s, writing into %s", this.lastWrittenKey, key, this.getFilename()));
        }
        return true;
    }

    private void startPartition(DecoratedKey key, DeletionTime partitionLevelDeletion) throws IOException {
        ((SortedTablePartitionWriter)this.partitionWriter).start(key, partitionLevelDeletion);
        this.metadataCollector.updatePartitionDeletion(partitionLevelDeletion);
        this.onStartPartition(key);
    }

    private void addStaticRow(DecoratedKey key, Row row) throws IOException {
        this.guardCollectionSize(key, row);
        ((SortedTablePartitionWriter)this.partitionWriter).addStaticRow(row);
        if (!row.isEmpty()) {
            Rows.collectStats(row, this.metadataCollector);
        }
        this.onStaticRow(row);
    }

    private void addUnfiltered(DecoratedKey key, Unfiltered unfiltered) throws IOException {
        if (unfiltered.isRow()) {
            this.addRow(key, (Row)unfiltered);
        } else {
            this.addRangeTomstoneMarker((RangeTombstoneMarker)unfiltered);
        }
    }

    private void addRow(DecoratedKey key, Row row) throws IOException {
        this.guardCollectionSize(key, row);
        ((SortedTablePartitionWriter)this.partitionWriter).addUnfiltered(row);
        this.metadataCollector.updateClusteringValues((Clustering<?>)row.clustering());
        Rows.collectStats(row, this.metadataCollector);
        this.onRow(row);
    }

    private void addRangeTomstoneMarker(RangeTombstoneMarker marker) throws IOException {
        ((SortedTablePartitionWriter)this.partitionWriter).addUnfiltered(marker);
        this.metadataCollector.updateClusteringValuesByBoundOrBoundary((ClusteringBoundOrBoundary<?>)marker.clustering());
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            this.metadataCollector.update(bm.endDeletionTime());
            this.metadataCollector.update(bm.startDeletionTime());
        } else {
            this.metadataCollector.update(((RangeTombstoneBoundMarker)marker).deletionTime());
        }
        this.onRangeTombstoneMarker(marker);
    }

    private AbstractRowIndexEntry endPartition(DecoratedKey key, DeletionTime partitionLevelDeletion) throws IOException {
        long finishResult = ((SortedTablePartitionWriter)this.partitionWriter).finish();
        long endPosition = this.dataWriter.position();
        long rowSize = endPosition - ((SortedTablePartitionWriter)this.partitionWriter).getInitialPosition();
        this.guardPartitionThreshold(Guardrails.partitionSize, key, rowSize);
        this.guardPartitionThreshold(Guardrails.partitionTombstones, key, this.metadataCollector.totalTombstones);
        this.metadataCollector.addPartitionSizeInBytes(rowSize);
        this.metadataCollector.addKey(key.getKey());
        this.metadataCollector.addCellPerPartitionCount();
        this.last = this.lastWrittenKey = key;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote {} at {}", (Object)key, (Object)endPosition);
        }
        return this.createRowIndexEntry(key, partitionLevelDeletion, finishResult);
    }

    protected void onStartPartition(DecoratedKey key) {
        this.notifyObservers(o -> o.startPartition(key, ((SortedTablePartitionWriter)this.partitionWriter).getInitialPosition(), ((SortedTablePartitionWriter)this.partitionWriter).getInitialPosition()));
    }

    protected void onStaticRow(Row row) {
        this.notifyObservers(o -> o.staticRow(row));
    }

    protected void onRow(Row row) {
        this.notifyObservers(o -> o.nextUnfilteredCluster(row));
    }

    protected void onRangeTombstoneMarker(RangeTombstoneMarker marker) {
        this.notifyObservers(o -> o.nextUnfilteredCluster(marker));
    }

    protected abstract AbstractRowIndexEntry createRowIndexEntry(DecoratedKey var1, DeletionTime var2, long var3) throws IOException;

    protected final void notifyObservers(Consumer<SSTableFlushObserver> action) {
        if (this.observers != null && !this.observers.isEmpty()) {
            this.observers.forEach(action);
        }
    }

    @Override
    public void mark() {
        this.dataMark = this.dataWriter.mark();
        ((AbstractIndexWriter)this.indexWriter).mark();
    }

    @Override
    public void resetAndTruncate() {
        this.dataWriter.resetAndTruncate(this.dataMark);
        ((SortedTablePartitionWriter)this.partitionWriter).reset();
        ((AbstractIndexWriter)this.indexWriter).resetAndTruncate();
    }

    @Override
    protected SSTableWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy(() -> FBUtilities.immutableListWithFilteredNulls(this.indexWriter, this.dataWriter));
    }

    @Override
    public long getFilePointer() {
        return this.dataWriter.position();
    }

    @Override
    public long getOnDiskFilePointer() {
        return this.dataWriter.getOnDiskFilePointer();
    }

    @Override
    public long getEstimatedOnDiskBytesWritten() {
        return this.dataWriter.getEstimatedOnDiskBytesWritten();
    }

    protected FileHandle openDataFile(long lengthOverride, StatsMetadata statsMetadata) {
        FileHandle dataFile;
        int dataBufferSize = this.ioOptions.diskOptimizationStrategy.bufferSize(statsMetadata.estimatedPartitionSize.percentile(this.ioOptions.diskOptimizationEstimatePercentile));
        try (CompressionMetadata compressionMetadata = this.compression ? ((CompressedSequentialWriter)this.dataWriter).open(lengthOverride) : null;){
            dataFile = this.dataFileBuilder.mmapped(this.ioOptions.defaultDiskAccessMode).withMmappedRegionsCache(this.mmappedRegionsCache).withChunkCache(this.chunkCache).withCompressionMetadata(compressionMetadata).bufferSize(dataBufferSize).withCrcCheckChance(this.crcCheckChanceSupplier).withLengthOverride(lengthOverride).complete();
        }
        try {
            if (this.chunkCache != null && this.lastEarlyOpenLength != 0L && dataFile.dataLength() > this.lastEarlyOpenLength) {
                this.chunkCache.invalidatePosition(dataFile, this.lastEarlyOpenLength);
            }
            this.lastEarlyOpenLength = dataFile.dataLength();
        }
        catch (Error | RuntimeException ex) {
            Throwables.closeNonNullAndAddSuppressed(ex, dataFile);
            throw ex;
        }
        return dataFile;
    }

    private void guardPartitionThreshold(Threshold guardrail, DecoratedKey key, long size) {
        if (guardrail.triggersOn(size, null)) {
            String message = String.format("%s.%s:%s on sstable %s", this.metadata.keyspace, this.metadata.name, this.metadata().partitionKeyType.getString(key.getKey()), this.getFilename());
            guardrail.guard(size, message, true, null);
        }
    }

    private void guardCollectionSize(DecoratedKey partitionKey, Row row) {
        if (!Guardrails.collectionSize.enabled() && !Guardrails.itemsPerCollection.enabled()) {
            return;
        }
        if (row.isEmpty() || SchemaConstants.isSystemKeyspace(this.metadata.keyspace)) {
            return;
        }
        for (ColumnMetadata column : row.columns()) {
            ComplexColumnData liveCells;
            ComplexColumnData cells;
            if (!column.type.isCollection() || !column.type.isMultiCell() || (cells = row.getComplexColumnData(column)) == null || (liveCells = cells.purge(DeletionPurger.PURGE_ALL, FBUtilities.nowInSeconds())) == null) continue;
            int cellsSize = liveCells.dataSize();
            int cellsCount = liveCells.cellsCount();
            if (!Guardrails.collectionSize.triggersOn(cellsSize, null) && !Guardrails.itemsPerCollection.triggersOn(cellsCount, null)) continue;
            String keyString = this.metadata.getLocal().primaryKeyAsCQLLiteral(partitionKey.getKey(), (Clustering<?>)row.clustering());
            String msg = String.format("%s in row %s in table %s", column.name.toString(), keyString, this.metadata);
            Guardrails.collectionSize.guard(cellsSize, msg, true, null);
            Guardrails.itemsPerCollection.guard(cellsCount, msg, true, null);
        }
    }

    public static abstract class Builder<P extends SortedTablePartitionWriter, I extends AbstractIndexWriter, W extends SortedTableWriter<P, I>, B extends Builder<P, I, W, B>>
    extends SSTableWriter.Builder<W, B> {
        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        @Override
        public B addDefaultComponents(Collection<Index.Group> indexGroups) {
            super.addDefaultComponents(indexGroups);
            if (FilterComponent.shouldUseBloomFilter(this.getTableMetadataRef().getLocal().params.bloomFilterFpChance)) {
                this.addComponents(ImmutableSet.of(SSTableFormat.Components.FILTER));
            }
            return (B)this;
        }

        protected abstract SequentialWriter openDataWriter();

        protected abstract I openIndexWriter(SequentialWriter var1);

        protected abstract P openPartitionWriter(SequentialWriter var1, I var2);
    }

    protected static abstract class AbstractIndexWriter
    extends Transactional.AbstractTransactional
    implements Transactional {
        protected final Descriptor descriptor;
        protected final TableMetadataRef metadata;
        protected final Set<Component> components;
        protected final IFilter bf;

        protected AbstractIndexWriter(Builder<?, ?, ?, ?> b) {
            this.descriptor = b.descriptor;
            this.metadata = b.getTableMetadataRef();
            this.components = b.getComponents();
            this.bf = FilterFactory.getFilter(b.getKeyCount(), b.getTableMetadataRef().getLocal().params.bloomFilterFpChance);
        }

        protected void flushBf() {
            if (this.components.contains(SSTableFormat.Components.FILTER)) {
                try {
                    FilterComponent.save(this.bf, this.descriptor, true);
                }
                catch (IOException ex) {
                    throw new FSWriteError((Throwable)ex, this.descriptor.fileFor(SSTableFormat.Components.FILTER));
                }
            }
        }

        public abstract void mark();

        public abstract void resetAndTruncate();

        @Override
        protected void doPrepare() {
            this.flushBf();
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = this.bf.close(accumulate);
            return accumulate;
        }

        public IFilter getFilterCopy() {
            return this.bf.sharedCopy();
        }
    }

    protected class TransactionalProxy
    extends SSTableWriter.TransactionalProxy {
        public TransactionalProxy(Supplier<ImmutableList<Transactional>> transactionals) {
            super(transactionals);
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = Throwables.close(accumulate, new AutoCloseable[]{SortedTableWriter.this.partitionWriter});
            accumulate = super.doPostCleanup(accumulate);
            return accumulate;
        }
    }
}

