/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexEntry;
import org.apache.cassandra.index.sai.utils.TermsIterator;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public class MemtableTermsIterator
implements TermsIterator {
    private final ByteBuffer minTerm;
    private final ByteBuffer maxTerm;
    private final Iterator<Pair<ByteComparable, LongArrayList>> iterator;
    private Pair<ByteComparable, LongArrayList> current;
    private long maxSSTableRowId = -1L;
    private long minSSTableRowId = Long.MAX_VALUE;

    public MemtableTermsIterator(ByteBuffer minTerm, ByteBuffer maxTerm, Iterator<Pair<ByteComparable, LongArrayList>> iterator) {
        Preconditions.checkArgument(iterator != null);
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.iterator = iterator;
    }

    @Override
    public ByteBuffer getMinTerm() {
        return this.minTerm;
    }

    @Override
    public ByteBuffer getMaxTerm() {
        return this.maxTerm;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public IndexEntry next() {
        this.current = this.iterator.next();
        return IndexEntry.create((ByteComparable)this.current.left, this.postings());
    }

    public long getMaxSSTableRowId() {
        return this.maxSSTableRowId;
    }

    public long getMinSSTableRowId() {
        return this.minSSTableRowId;
    }

    private PostingList postings() {
        final LongArrayList list = (LongArrayList)this.current.right;
        assert (list.size() > 0);
        long minSegmentRowID = list.get(0);
        long maxSegmentRowID = list.get(list.size() - 1);
        this.minSSTableRowId = Math.min(this.minSSTableRowId, minSegmentRowID);
        this.maxSSTableRowId = Math.max(this.maxSSTableRowId, maxSegmentRowID);
        final Iterator<LongCursor> it = list.iterator();
        return new PostingList(){

            @Override
            public long nextPosting() {
                if (!it.hasNext()) {
                    return Long.MAX_VALUE;
                }
                return ((LongCursor)it.next()).value;
            }

            @Override
            public long size() {
                return list.size();
            }

            @Override
            public long advance(long targetRowID) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

