/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.keystore;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.v1.MetadataWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesWriter;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyLookupMeta;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

@NotThreadSafe
public class KeyStoreWriter
implements Closeable {
    private final int blockShift;
    private final int blockMask;
    private final boolean clustering;
    private final IndexOutput keysOutput;
    private final NumericValuesWriter offsetsWriter;
    private final String componentName;
    private final MetadataWriter metadataWriter;
    private BytesRefBuilder prevKey = new BytesRefBuilder();
    private BytesRefBuilder tempKey = new BytesRefBuilder();
    private final long bytesStartFP;
    private boolean inPartition = false;
    private int maxKeyLength = -1;
    private long pointId = 0L;

    public KeyStoreWriter(String componentName, MetadataWriter metadataWriter, IndexOutput keysOutput, NumericValuesWriter keysBlockOffsets, int blockShift, boolean clustering) throws IOException {
        this.componentName = componentName;
        this.metadataWriter = metadataWriter;
        SAICodecUtils.writeHeader(keysOutput);
        this.blockShift = blockShift;
        this.blockMask = (1 << this.blockShift) - 1;
        this.clustering = clustering;
        this.keysOutput = keysOutput;
        this.keysOutput.writeVInt(blockShift);
        this.keysOutput.writeByte((byte)(clustering ? 1 : 0));
        this.bytesStartFP = keysOutput.getFilePointer();
        this.offsetsWriter = keysBlockOffsets;
    }

    public void startPartition() {
        assert (this.clustering) : "Cannot start a partition on a non-clustering key store";
        this.inPartition = false;
    }

    public void add(@Nonnull ByteComparable key) throws IOException {
        this.tempKey.clear();
        this.copyBytes(key, this.tempKey);
        BytesRef keyRef = this.tempKey.get();
        if (this.clustering && this.inPartition && this.compareKeys(keyRef, this.prevKey.get()) <= 0) {
            throw new IllegalArgumentException("Clustering keys must be in ascending lexographical order");
        }
        this.inPartition = true;
        this.writeKey(keyRef);
        this.maxKeyLength = Math.max(this.maxKeyLength, keyRef.length);
        BytesRefBuilder temp = this.tempKey;
        this.tempKey = this.prevKey;
        this.prevKey = temp;
        ++this.pointId;
    }

    private void writeKey(BytesRef key) throws IOException {
        if ((this.pointId & (long)this.blockMask) == 0L) {
            this.offsetsWriter.add(this.keysOutput.getFilePointer() - this.bytesStartFP);
            this.keysOutput.writeVInt(key.length);
            this.keysOutput.writeBytes(key.bytes, key.offset, key.length);
        } else {
            int prefixLength = 0;
            int suffixLength = 0;
            if (this.compareKeys(this.prevKey.get(), key) != 0) {
                prefixLength = StringHelper.bytesDifference(this.prevKey.get(), key);
                suffixLength = key.length - prefixLength;
            }
            this.keysOutput.writeByte((byte)(Math.min(prefixLength, 15) | Math.min(15, suffixLength) << 4));
            if (prefixLength + suffixLength > 0) {
                if (prefixLength >= 15) {
                    this.keysOutput.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 15) {
                    this.keysOutput.writeVInt(suffixLength - 15);
                }
                this.keysOutput.writeBytes(key.bytes, key.offset + prefixLength, key.length - prefixLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try (MetadataWriter.Builder output = this.metadataWriter.builder(this.componentName);){
            SAICodecUtils.writeFooter(this.keysOutput);
            KeyLookupMeta.write(output, this.pointId, this.maxKeyLength);
        }
        catch (Throwable throwable) {
            FileUtils.close(this.offsetsWriter, this.keysOutput);
            throw throwable;
        }
        FileUtils.close(this.offsetsWriter, this.keysOutput);
    }

    private int compareKeys(BytesRef left, BytesRef right) {
        return FastByteOperations.compareUnsigned(left.bytes, left.offset, left.offset + left.length, right.bytes, right.offset, right.offset + right.length);
    }

    private void copyBytes(ByteComparable source, BytesRefBuilder dest) {
        int val;
        ByteSource byteSource = source.asComparableBytes(ByteComparable.Version.OSS50);
        while ((val = byteSource.next()) != -1) {
            dest.append((byte)val);
        }
    }
}

