/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.IOException;
import org.apache.cassandra.index.sai.disk.v1.bitpack.AbstractBlockPackedWriter;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.packed.DirectWriter;

public class BlockPackedWriter
extends AbstractBlockPackedWriter {
    static final int BPV_SHIFT = 1;
    static final int MIN_VALUE_EQUALS_0 = 1;

    public BlockPackedWriter(IndexOutput out, int blockSize) {
        super(out, blockSize);
    }

    @Override
    protected void flushBlock() throws IOException {
        long min2 = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.blockIndex; ++i) {
            min2 = Math.min(this.blockValues[i], min2);
            max = Math.max(this.blockValues[i], max);
        }
        long delta = max - min2;
        int bitsRequired = delta == 0L ? 0 : DirectWriter.unsignedBitsRequired(delta);
        int shiftedBitsRequired = bitsRequired << 1 | (min2 == 0L ? 1 : 0);
        this.blockMetaWriter.writeByte((byte)shiftedBitsRequired);
        if (min2 != 0L) {
            this.writeVLong(this.blockMetaWriter, BitUtil.zigZagEncode(min2) - 1L);
        }
        if (bitsRequired > 0) {
            if (min2 != 0L) {
                int i = 0;
                while (i < this.blockIndex) {
                    int n = i++;
                    this.blockValues[n] = this.blockValues[n] - min2;
                }
            }
            this.blockMetaWriter.writeVLong(this.indexOutput.getFilePointer());
            this.writeValues(this.blockIndex, bitsRequired);
        }
    }
}

