/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.ThrottledUnfilteredIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.streaming.CassandraIncomingFile;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.StreamReceiver;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStreamReceiver
implements StreamReceiver {
    private static final Logger logger = LoggerFactory.getLogger(CassandraStreamReceiver.class);
    private static final int MAX_ROWS_PER_BATCH = CassandraRelevantProperties.REPAIR_MUTATION_REPAIR_ROWS_PER_BATCH.getInt();
    private final ColumnFamilyStore cfs;
    private final StreamSession session;
    private final LifecycleTransaction txn;
    protected final Collection<SSTableReader> sstables;
    protected volatile boolean receivedEntireSSTable;
    private final boolean requiresWritePath;

    public CassandraStreamReceiver(ColumnFamilyStore cfs, StreamSession session, int totalFiles) {
        this.cfs = cfs;
        this.session = session;
        this.txn = LifecycleTransaction.offline(OperationType.STREAM);
        this.sstables = new ArrayList<SSTableReader>(totalFiles);
        this.requiresWritePath = this.requiresWritePath(cfs);
    }

    public static CassandraStreamReceiver fromReceiver(StreamReceiver receiver) {
        Preconditions.checkArgument(receiver instanceof CassandraStreamReceiver);
        return (CassandraStreamReceiver)receiver;
    }

    private static CassandraIncomingFile getFile(IncomingStream stream) {
        Preconditions.checkArgument(stream instanceof CassandraIncomingFile, "Wrong stream type: {}", (Object)stream);
        return (CassandraIncomingFile)stream;
    }

    @Override
    public synchronized void received(IncomingStream stream) {
        CassandraIncomingFile file = CassandraStreamReceiver.getFile(stream);
        Collection<SSTableReader> finished = null;
        SSTableMultiWriter sstable = file.getSSTable();
        try {
            finished = sstable.finish(true);
        }
        catch (Throwable t2) {
            Throwables.maybeFail(sstable.abort(t2));
        }
        this.txn.update(finished, false);
        this.sstables.addAll(finished);
        this.receivedEntireSSTable = file.isEntireSSTable();
    }

    @Override
    public void discardStream(IncomingStream stream) {
        CassandraIncomingFile file = CassandraStreamReceiver.getFile(stream);
        Throwables.maybeFail(file.getSSTable().abort(null));
    }

    public synchronized LifecycleNewTracker createLifecycleNewTracker() {
        return new LifecycleNewTracker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void trackNew(SSTable table) {
                CassandraStreamReceiver cassandraStreamReceiver = CassandraStreamReceiver.this;
                synchronized (cassandraStreamReceiver) {
                    CassandraStreamReceiver.this.txn.trackNew(table);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void untrackNew(SSTable table) {
                CassandraStreamReceiver cassandraStreamReceiver = CassandraStreamReceiver.this;
                synchronized (cassandraStreamReceiver) {
                    CassandraStreamReceiver.this.txn.untrackNew(table);
                }
            }

            @Override
            public OperationType opType() {
                return CassandraStreamReceiver.this.txn.opType();
            }
        };
    }

    @Override
    public synchronized void abort() {
        this.sstables.clear();
        this.txn.abort();
    }

    private boolean hasViews(ColumnFamilyStore cfs) {
        return !Iterables.isEmpty(View.findAll(cfs.metadata.keyspace, cfs.getTableName()));
    }

    private boolean hasCDC(ColumnFamilyStore cfs) {
        return cfs.metadata().params.cdc;
    }

    private boolean cdcRequiresWriteCommitLog(ColumnFamilyStore cfs) {
        return DatabaseDescriptor.isCDCOnRepairEnabled() && this.hasCDC(cfs);
    }

    private boolean requiresWritePath(ColumnFamilyStore cfs) {
        return this.cdcRequiresWriteCommitLog(cfs) || cfs.streamToMemtable() || this.session.streamOperation().requiresViewBuild() && this.hasViews(cfs);
    }

    private void sendThroughWritePath(ColumnFamilyStore cfs, Collection<SSTableReader> readers) {
        boolean writeCDCCommitLog = this.cdcRequiresWriteCommitLog(cfs);
        ColumnFilter filter = ColumnFilter.all(cfs.metadata());
        for (SSTableReader reader : readers) {
            Keyspace ks = Keyspace.open(reader.getKeyspaceName());
            ISSTableScanner scanner = reader.getScanner();
            try {
                CloseableIterator<UnfilteredRowIterator> throttledPartitions = ThrottledUnfilteredIterator.throttle(scanner, MAX_ROWS_PER_BATCH);
                try {
                    while (throttledPartitions.hasNext()) {
                        ks.apply(new Mutation(PartitionUpdate.fromIterator((UnfilteredRowIterator)throttledPartitions.next(), filter)), writeCDCCommitLog, true, false);
                    }
                }
                finally {
                    if (throttledPartitions == null) continue;
                    throttledPartitions.close();
                }
            }
            finally {
                if (scanner == null) continue;
                scanner.close();
            }
        }
    }

    public synchronized void finishTransaction() {
        this.txn.finish();
    }

    @Override
    public void finished() {
        boolean requiresWritePath = this.requiresWritePath(this.cfs);
        Collection<SSTableReader> readers = this.sstables;
        try (Refs<SSTableReader> refs = Refs.ref(readers);){
            if (requiresWritePath) {
                this.sendThroughWritePath(this.cfs, readers);
            } else {
                if (this.receivedEntireSSTable) {
                    this.cfs.indexManager.validateSSTableAttachedIndexes(readers, true, true);
                }
                this.finishTransaction();
                logger.debug("[Stream #{}] Received {} sstables from {} ({})", new Object[]{this.session.planId(), readers.size(), this.session.peer, readers});
                this.cfs.addSSTables(readers);
                if (this.cfs.isRowCacheEnabled() || this.cfs.metadata().isCounter()) {
                    int invalidatedKeys;
                    ArrayList boundsToInvalidate = new ArrayList(readers.size());
                    readers.forEach(sstable -> boundsToInvalidate.add(new Bounds<Token>(sstable.getFirst().getToken(), sstable.getLast().getToken())));
                    Set<Bounds<Token>> nonOverlappingBounds = Bounds.getNonOverlappingBounds(boundsToInvalidate);
                    if (this.cfs.isRowCacheEnabled() && (invalidatedKeys = this.cfs.invalidateRowCache(nonOverlappingBounds)) > 0) {
                        logger.debug("[Stream #{}] Invalidated {} row cache entries on table {}.{} after stream receive task completed.", new Object[]{this.session.planId(), invalidatedKeys, this.cfs.getKeyspaceName(), this.cfs.getTableName()});
                    }
                    if (this.cfs.metadata().isCounter() && (invalidatedKeys = this.cfs.invalidateCounterCache(nonOverlappingBounds)) > 0) {
                        logger.debug("[Stream #{}] Invalidated {} counter cache entries on table {}.{} after stream receive task completed.", new Object[]{this.session.planId(), invalidatedKeys, this.cfs.getKeyspaceName(), this.cfs.getTableName()});
                    }
                }
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.requiresWritePath) {
            this.cfs.forceBlockingFlush(ColumnFamilyStore.FlushReason.STREAMS_RECEIVED);
            this.abort();
        }
    }
}

