/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.annotations.VisibleForTesting;
import com.sun.nio.file.ExtendedOpenOption;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SimpleCachedBufferPool;
import org.apache.cassandra.utils.ByteBufferUtil;
import sun.nio.ch.DirectBuffer;

public class DirectIOSegment
extends CommitLogSegment {
    private final int fsBlockSize;
    private final int fsBlockRemainderMask;
    long lastWritten = 0L;

    DirectIOSegment(AbstractCommitLogSegmentManager manager, ThrowingFunction<Path, FileChannel, IOException> channelFactory, int fsBlockSize) {
        super(manager, channelFactory);
        assert (Integer.highestOneBit(fsBlockSize) == fsBlockSize) : "fsBlockSize must be a power of 2";
        int firstSync = this.buffer.position();
        this.buffer.putInt(firstSync + 0, 0);
        this.buffer.putInt(firstSync + 4, 0);
        this.fsBlockSize = fsBlockSize;
        this.fsBlockRemainderMask = fsBlockSize - 1;
    }

    @Override
    void writeLogHeader() {
        super.writeLogHeader();
        this.flush(0, this.lastSyncedOffset);
    }

    @Override
    void write(int startMarker, int nextMarker) {
        if (nextMarker <= this.buffer.capacity() - 8) {
            this.buffer.putInt(nextMarker, 0);
            this.buffer.putInt(nextMarker + 4, 0);
        }
        DirectIOSegment.writeSyncMarker(this.id, this.buffer, startMarker, startMarker, nextMarker);
    }

    @Override
    protected void flush(int startMarker, int nextMarker) {
        try {
            int flushPosition = this.lastSyncedOffset;
            ByteBuffer duplicate = this.buffer.duplicate();
            if ((flushPosition & this.fsBlockRemainderMask) != 0) {
                this.channel.position(flushPosition &= -this.fsBlockSize);
            }
            duplicate.position(flushPosition);
            int flushLimit = nextMarker;
            flushLimit = flushLimit + this.fsBlockSize - 1 & -this.fsBlockSize;
            duplicate.limit(flushLimit);
            this.channel.write(duplicate);
            if ((long)flushLimit > this.lastWritten) {
                this.manager.addSize((long)flushLimit - this.lastWritten);
                this.lastWritten = flushLimit;
            }
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public long onDiskSize() {
        return this.lastWritten;
    }

    @Override
    protected void internalClose() {
        try {
            this.manager.getBufferPool().releaseBuffer(this.buffer);
            super.internalClose();
        }
        finally {
            this.manager.notifyBufferFreed();
        }
    }

    protected static class DirectIOSegmentBuilder
    extends CommitLogSegment.Builder {
        public final int fsBlockSize;

        public DirectIOSegmentBuilder(AbstractCommitLogSegmentManager segmentManager) {
            this(segmentManager, FileUtils.getBlockSize(new File(segmentManager.storageDirectory)));
        }

        @VisibleForTesting
        public DirectIOSegmentBuilder(AbstractCommitLogSegmentManager segmentManager, int fsBlockSize) {
            super(segmentManager);
            this.fsBlockSize = fsBlockSize;
        }

        @Override
        public DirectIOSegment build() {
            return new DirectIOSegment(this.segmentManager, path -> FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.DSYNC, ExtendedOpenOption.DIRECT), this.fsBlockSize);
        }

        @Override
        public SimpleCachedBufferPool createBufferPool() {
            return new SimpleCachedBufferPool(DatabaseDescriptor.getCommitLogMaxCompressionBuffersInPool(), DatabaseDescriptor.getCommitLogSegmentSize() + this.fsBlockSize - 1, BufferType.OFF_HEAP){

                @Override
                public ByteBuffer createBuffer() {
                    int segmentSize = DatabaseDescriptor.getCommitLogSegmentSize();
                    ByteBuffer original = super.createBuffer();
                    ByteBufferUtil.writeZeroes(original.duplicate(), original.limit());
                    ByteBuffer alignedBuffer = original.alignedSlice(fsBlockSize);
                    assert (alignedBuffer.limit() == segmentSize) : String.format("Bytebuffer slicing failed to get required buffer size (required=%d, current size=%d", segmentSize, alignedBuffer.limit());
                    assert (alignedBuffer.limit() == alignedBuffer.capacity()) : String.format("Bytebuffer limit and capacity do not match (limit=%d, capacity=%d", alignedBuffer.limit(), alignedBuffer.capacity());
                    assert (alignedBuffer.alignmentOffset(0, fsBlockSize) == 0) : String.format("Index 0 should be aligned to %d page size.", fsBlockSize);
                    assert (alignedBuffer.alignmentOffset(alignedBuffer.limit(), fsBlockSize) == 0) : String.format("Limit should be aligned to %d page size", fsBlockSize);
                    return alignedBuffer;
                }

                @Override
                public void releaseBuffer(ByteBuffer buffer) {
                    ByteBuffer original = (ByteBuffer)((DirectBuffer)((Object)buffer)).attachment();
                    assert (original != null);
                    super.releaseBuffer(original);
                }
            };
        }
    }
}

