/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UserFunction;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.UserFunctions;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropAggregateStatement
extends AlterSchemaStatement {
    private final String aggregateName;
    private final List<CQL3Type.Raw> arguments;
    private final boolean argumentsSpeficied;
    private final boolean ifExists;

    public DropAggregateStatement(String keyspaceName, String aggregateName, List<CQL3Type.Raw> arguments, boolean argumentsSpeficied, boolean ifExists) {
        super(keyspaceName);
        this.aggregateName = aggregateName;
        this.arguments = arguments;
        this.argumentsSpeficied = argumentsSpeficied;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        UserFunction aggregate;
        String name = this.argumentsSpeficied ? String.format("%s.%s(%s)", this.keyspaceName, this.aggregateName, String.join((CharSequence)", ", Iterables.transform(this.arguments, Object::toString))) : String.format("%s.%s", this.keyspaceName, this.aggregateName);
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            if (this.ifExists) {
                return schema;
            }
            throw DropAggregateStatement.ire("Aggregate '%s' doesn't exist", name);
        }
        Collection<UserFunction> aggregates = keyspace.userFunctions.get(new FunctionName(this.keyspaceName, this.aggregateName));
        if (aggregates.size() > 1 && !this.argumentsSpeficied) {
            throw DropAggregateStatement.ire("'DROP AGGREGATE %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP AGGREGATE %s (type, type, ...)'. You can use cqlsh 'DESCRIBE AGGREGATE %s' command to find all overloads", this.aggregateName, this.aggregateName, this.aggregateName);
        }
        this.arguments.stream().filter(raw -> !raw.isImplicitlyFrozen() && raw.isFrozen()).findFirst().ifPresent(t2 -> {
            throw DropAggregateStatement.ire("Argument '%s' cannot be frozen; remove frozen<> modifier from '%s'", t2, t2);
        });
        List<AbstractType<?>> argumentTypes = this.prepareArgumentTypes(keyspace.types);
        Predicate<UserFunction> filter = UserFunctions.Filter.UDA;
        if (this.argumentsSpeficied) {
            filter = filter.and(f -> f.typesMatch(argumentTypes));
        }
        if (null == (aggregate = (UserFunction)aggregates.stream().filter(filter).findAny().orElse(null))) {
            if (this.ifExists) {
                return schema;
            }
            throw DropAggregateStatement.ire("Aggregate '%s' doesn't exist", name);
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.userFunctions.without(aggregate)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        UserFunctions dropped = (UserFunctions)((KeyspaceMetadata.KeyspaceDiff)diff.altered.get((int)0)).udas.dropped;
        assert (dropped.size() == 1);
        return Event.SchemaChange.forAggregate(Event.SchemaChange.Change.DROPPED, (UDAggregate)dropped.iterator().next());
    }

    @Override
    public void authorize(ClientState client) {
        KeyspaceMetadata keyspace = Schema.instance.getKeyspaceMetadata(this.keyspaceName);
        if (null == keyspace) {
            return;
        }
        Stream<UserFunction> functions = keyspace.userFunctions.get(new FunctionName(this.keyspaceName, this.aggregateName)).stream();
        if (this.argumentsSpeficied) {
            functions = functions.filter(f -> f.typesMatch(this.prepareArgumentTypes(keyspace.types)));
        }
        functions.forEach(f -> client.ensurePermission(Permission.DROP, FunctionResource.function(f)));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_AGGREGATE, this.keyspaceName, this.aggregateName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.aggregateName);
    }

    private List<AbstractType<?>> prepareArgumentTypes(Types types) {
        return this.arguments.stream().map(t2 -> t2.prepare(this.keyspaceName, types)).map(t2 -> t2.getType().udfType()).collect(Collectors.toList());
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final FunctionName name;
        private final List<CQL3Type.Raw> arguments;
        private final boolean argumentsSpecified;
        private final boolean ifExists;

        public Raw(FunctionName name, List<CQL3Type.Raw> arguments, boolean argumentsSpecified, boolean ifExists) {
            this.name = name;
            this.arguments = arguments;
            this.argumentsSpecified = argumentsSpecified;
            this.ifExists = ifExists;
        }

        @Override
        public DropAggregateStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.keyspace : state.getKeyspace();
            return new DropAggregateStatement(keyspaceName, this.name.name, this.arguments, this.argumentsSpecified, this.ifExists);
        }
    }
}

