/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.cql3.CqlBuilder;
import org.apache.cassandra.cql3.SchemaElement;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDFDataType;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UserFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.schema.UserFunctions;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDAggregate
extends UserFunction
implements AggregateFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDAggregate.class);
    private final UDFDataType stateType;
    private final List<UDFDataType> argumentTypes;
    private final UDFDataType resultType;
    protected final ByteBuffer initcond;
    private final ScalarFunction stateFunction;
    private final ScalarFunction finalFunction;

    public UDAggregate(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, ScalarFunction stateFunc, ScalarFunction finalFunc, ByteBuffer initcond) {
        super(name, argTypes, returnType);
        this.stateFunction = stateFunc;
        this.finalFunction = finalFunc;
        this.argumentTypes = UDFDataType.wrap(argTypes, false);
        this.resultType = UDFDataType.wrap(returnType, false);
        this.stateType = stateFunc != null ? UDFDataType.wrap(stateFunc.returnType(), false) : null;
        this.initcond = initcond;
    }

    public static UDAggregate create(Collection<UDFunction> functions, FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, FunctionName stateFunc, FunctionName finalFunc, AbstractType<?> stateType, ByteBuffer initcond) {
        ArrayList stateTypes = new ArrayList(argTypes.size() + 1);
        stateTypes.add(stateType);
        stateTypes.addAll(argTypes);
        List<AbstractType<?>> finalTypes = Collections.singletonList(stateType);
        return new UDAggregate(name, argTypes, returnType, UDAggregate.findFunction(name, functions, stateFunc, stateTypes), null == finalFunc ? null : UDAggregate.findFunction(name, functions, finalFunc, finalTypes), initcond);
    }

    private static UDFunction findFunction(FunctionName udaName, Collection<UDFunction> functions, FunctionName name, List<AbstractType<?>> arguments) {
        return functions.stream().filter(f -> f.name().equals(name) && f.typesMatch(arguments)).findFirst().orElseThrow(() -> new ConfigurationException(String.format("Unable to find function %s referenced by UDA %s", name, udaName)));
    }

    @Override
    public boolean isPure() {
        return false;
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return FunctionArguments.newInstanceForUdf(version, this.argumentTypes);
    }

    public boolean hasReferenceTo(Function function) {
        return this.stateFunction == function || this.finalFunction == function;
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return Iterables.any(this.argTypes(), t2 -> t2.referencesUserType(name)) || this.returnType.referencesUserType(name) || null != this.stateType && this.stateType.toAbstractType().referencesUserType(name) || this.stateFunction.referencesUserType(name) || null != this.finalFunction && this.finalFunction.referencesUserType(name);
    }

    public UDAggregate withUpdatedUserType(Collection<UDFunction> udfs, UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        return new UDAggregate(this.name, Lists.newArrayList(Iterables.transform(this.argTypes, t2 -> t2.withUpdatedUserType(udt))), this.returnType.withUpdatedUserType(udt), UDAggregate.findFunction(this.name, udfs, this.stateFunction.name(), this.stateFunction.argTypes()), null == this.finalFunction ? null : UDAggregate.findFunction(this.name, udfs, this.finalFunction.name(), this.finalFunction.argTypes()), this.initcond);
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        functions.add(this);
        this.stateFunction.addFunctionsTo(functions);
        if (this.finalFunction != null) {
            this.finalFunction.addFunctionsTo(functions);
        }
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    public ScalarFunction stateFunction() {
        return this.stateFunction;
    }

    public ScalarFunction finalFunction() {
        return this.finalFunction;
    }

    public ByteBuffer initialCondition() {
        return this.initcond;
    }

    public AbstractType<?> stateType() {
        return this.stateType == null ? null : this.stateType.toAbstractType();
    }

    @Override
    public AggregateFunction.Aggregate newAggregate() throws InvalidRequestException {
        return new AggregateFunction.Aggregate(){
            private long stateFunctionCount;
            private long stateFunctionDuration;
            private Object state;
            private boolean needsInit = true;

            @Override
            public void addInput(Arguments arguments) throws InvalidRequestException {
                this.maybeInit(arguments.getProtocolVersion());
                long startTime = Clock.Global.nanoTime();
                ++this.stateFunctionCount;
                if (UDAggregate.this.stateFunction instanceof UDFunction) {
                    UDFunction udf = (UDFunction)UDAggregate.this.stateFunction;
                    if (udf.isCallableWrtNullable(arguments)) {
                        this.state = udf.executeForAggregate(this.state, arguments);
                    }
                } else {
                    throw new UnsupportedOperationException("UDAs only support UDFs");
                }
                this.stateFunctionDuration += (Clock.Global.nanoTime() - startTime) / 1000L;
            }

            private void maybeInit(ProtocolVersion protocolVersion) {
                if (this.needsInit) {
                    this.state = UDAggregate.this.initcond != null ? UDAggregate.this.stateType.compose(protocolVersion, UDAggregate.this.initcond.duplicate()) : null;
                    this.stateFunctionDuration = 0L;
                    this.stateFunctionCount = 0L;
                    this.needsInit = false;
                }
            }

            @Override
            public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                this.maybeInit(protocolVersion);
                Tracing.trace("Executed UDA {}: {} call(s) to state function {} in {}\u03bcs", UDAggregate.this.name(), this.stateFunctionCount, UDAggregate.this.stateFunction.name(), this.stateFunctionDuration);
                if (UDAggregate.this.finalFunction == null) {
                    return UDAggregate.this.stateType.decompose(protocolVersion, this.state);
                }
                if (UDAggregate.this.finalFunction instanceof UDFunction) {
                    UDFunction udf = (UDFunction)UDAggregate.this.finalFunction;
                    Object result = udf.executeForAggregate(this.state, FunctionArguments.emptyInstance(protocolVersion));
                    return UDAggregate.this.resultType.decompose(protocolVersion, result);
                }
                throw new UnsupportedOperationException("UDAs only support UDFs");
            }

            @Override
            public void reset() {
                this.needsInit = true;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDAggregate)) {
            return false;
        }
        UDAggregate that = (UDAggregate)o;
        return this.equalsWithoutTypesAndFunctions(that) && this.argTypes.equals(that.argTypes) && this.returnType.equals(that.returnType) && Objects.equal(this.stateFunction, that.stateFunction) && Objects.equal(this.finalFunction, that.finalFunction) && (this.stateType == that.stateType || this.stateType != null && this.stateType.equals(that.stateType));
    }

    private boolean equalsWithoutTypesAndFunctions(UDAggregate other) {
        return this.name.equals(other.name) && this.argTypes.size() == other.argTypes.size() && Objects.equal(this.initcond, other.initcond);
    }

    @Override
    public Optional<Difference> compare(Function function) {
        if (!(function instanceof UDAggregate)) {
            throw new IllegalArgumentException();
        }
        UDAggregate other = (UDAggregate)function;
        if (!this.equalsWithoutTypesAndFunctions(other) || null == this.finalFunction != (null == other.finalFunction) || null == this.stateType != (null == other.stateType)) {
            return Optional.of(Difference.SHALLOW);
        }
        boolean differsDeeply = false;
        if (null != this.finalFunction && !this.finalFunction.equals(other.finalFunction)) {
            if (this.finalFunction.name().equals(other.finalFunction.name())) {
                differsDeeply = true;
            } else {
                return Optional.of(Difference.SHALLOW);
            }
        }
        if (null != this.stateType && !this.stateType.equals(other.stateType)) {
            if (this.stateType.toAbstractType().asCQL3Type().toString().equals(other.stateType.toAbstractType().asCQL3Type().toString())) {
                differsDeeply = true;
            } else {
                return Optional.of(Difference.SHALLOW);
            }
        }
        if (!this.returnType.equals(other.returnType)) {
            if (this.returnType.asCQL3Type().toString().equals(other.returnType.asCQL3Type().toString())) {
                differsDeeply = true;
            } else {
                return Optional.of(Difference.SHALLOW);
            }
        }
        for (int i = 0; i < this.argTypes().size(); ++i) {
            AbstractType thatType;
            AbstractType thisType = (AbstractType)this.argTypes.get(i);
            if (thisType.equals(thatType = (AbstractType)other.argTypes.get(i))) continue;
            if (thisType.asCQL3Type().toString().equals(thatType.asCQL3Type().toString())) {
                differsDeeply = true;
                continue;
            }
            return Optional.of(Difference.SHALLOW);
        }
        if (!this.stateFunction.equals(other.stateFunction)) {
            if (this.stateFunction.name().equals(other.stateFunction.name())) {
                differsDeeply = true;
            } else {
                return Optional.of(Difference.SHALLOW);
            }
        }
        return differsDeeply ? Optional.of(Difference.DEEP) : Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name, UserFunctions.typeHashCode(this.argTypes), UserFunctions.typeHashCode(this.returnType), this.stateFunction, this.finalFunction, this.stateType, this.initcond);
    }

    @Override
    public SchemaElement.SchemaElementType elementType() {
        return SchemaElement.SchemaElementType.AGGREGATE;
    }

    @Override
    public String toCqlString(boolean withInternals, boolean ifNotExists) {
        CqlBuilder builder = new CqlBuilder();
        builder.append("CREATE AGGREGATE ");
        if (ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(this.name()).append('(').appendWithSeparators(this.argTypes, (b, t2) -> b.append(this.toCqlString((AbstractType<?>)t2)), ", ").append(')').newLine().increaseIndent().append("SFUNC ").appendQuotingIfNeeded(this.stateFunction().name().name).newLine().append("STYPE ").append(this.toCqlString(this.stateType()));
        if (this.finalFunction() != null) {
            builder.newLine().append("FINALFUNC ").appendQuotingIfNeeded(this.finalFunction().name().name);
        }
        if (this.initialCondition() != null) {
            builder.newLine().append("INITCOND ").append(this.stateType().asCQL3Type().toCQLLiteral(this.initialCondition()));
        }
        return builder.append(";").toString();
    }
}

