/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.threads.AbstractLifecycleEventLoop;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.EventGroupBuilder;
import net.openhft.chronicle.threads.EventLoops;
import net.openhft.chronicle.threads.MediumEventLoop;
import net.openhft.chronicle.threads.MilliPauser;
import net.openhft.chronicle.threads.MonitorEventLoop;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.threads.PauserMonitor;
import net.openhft.chronicle.threads.ThreadMonitors;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.threads.VanillaEventLoop;
import net.openhft.chronicle.threads.internal.EventLoopStateRenderer;
import net.openhft.chronicle.threads.internal.EventLoopThreadHolder;
import net.openhft.chronicle.threads.internal.ThreadMonitorHarness;
import org.jetbrains.annotations.NotNull;

public class EventGroup
extends AbstractLifecycleEventLoop
implements EventLoop {
    public static final int CONC_THREADS = Jvm.getInteger("eventGroup.conc.threads", Jvm.getInteger("CONC_THREADS", Math.max(1, Runtime.getRuntime().availableProcessors() / 4)));
    private static final long REPLICATION_MONITOR_INTERVAL_MS = Jvm.getLong("REPLICATION_MONITOR_INTERVAL_MS", 500L);
    private static final long MONITOR_INTERVAL_MS = Jvm.getLong("MONITOR_INTERVAL_MS", 100L);
    static final Integer REPLICATION_EVENT_PAUSE_TIME = Jvm.getInteger("replicationEventPauseTime", 20);
    private static final boolean ENABLE_LOOP_BLOCK_MONITOR = !Jvm.getBoolean("disableLoopBlockMonitor");
    private static final long WAIT_TO_START_MS = Jvm.getInteger("eventGroup.wait.to.start.ms", 1000).intValue();
    private final AtomicInteger counter = new AtomicInteger();
    @NotNull
    private final EventLoop monitor;
    private final CoreEventLoop core;
    private final BlockingEventLoop blocking;
    @NotNull
    private final Pauser pauser;
    @NotNull
    private final Supplier<Pauser> concPauserSupplier;
    private final String concBinding;
    private final String bindingReplication;
    private final Set<HandlerPriority> priorities;
    @NotNull
    private final List<VanillaEventLoop> concThreads = new CopyOnWriteArrayList<VanillaEventLoop>();
    private final MilliPauser milliPauser = Pauser.millis(50);
    private final boolean daemon;
    private final Pauser replicationPauser;
    @NotNull
    private final Supplier<Pauser> blockingPauserSupplier;
    private VanillaEventLoop replication;

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, String binding, String bindingReplication, String name, int concThreadsNum, Set<HandlerPriority> priorities) {
        this(daemon, pauser, null, binding, bindingReplication, name, concThreadsNum, "none", Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME), priorities);
    }

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, String binding, String bindingReplication, String name, int concThreadsNum, String concBinding, @NotNull Pauser concPauser, Set<HandlerPriority> priorities) {
        this(daemon, pauser, null, binding, bindingReplication, name, concThreadsNum, concBinding, concPauser, priorities);
    }

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, Pauser replicationPauser, String binding, String bindingReplication, String name, int concThreadsNum, String concBinding, @NotNull Pauser concPauser, Set<HandlerPriority> priorities) {
        this(daemon, pauser, replicationPauser, binding, bindingReplication, name, concThreadsNum, concBinding, () -> {
            Jvm.warn().on(EventGroup.class, "You've provided a single Pauser as your concurrent Pauser, this may not be thread safe, we recommend you migrate to the new constructor where a Supplier<Pauser> can be provided");
            return concPauser;
        }, priorities, PauserMode.balanced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventGroup(boolean daemon, @NotNull Pauser pauser, Pauser replicationPauser, String binding, String bindingReplication, String name, int concThreadsNum, String concBinding, @NotNull Supplier<Pauser> concPauserSupplier, Set<HandlerPriority> priorities, @NotNull Supplier<Pauser> blockingPauserSupplier) {
        super(name);
        this.daemon = daemon;
        this.pauser = pauser;
        this.replicationPauser = replicationPauser;
        this.concBinding = concBinding;
        this.concPauserSupplier = concPauserSupplier;
        this.bindingReplication = bindingReplication;
        this.priorities = EnumSet.copyOf(priorities);
        this.blockingPauserSupplier = blockingPauserSupplier;
        ArrayList<EventLoop> closeable = new ArrayList<EventLoop>();
        try {
            Set corePriorities = priorities.stream().filter(VanillaEventLoop.ALLOWED_PRIORITIES::contains).collect(Collectors.toSet());
            this.core = priorities.stream().anyMatch(VanillaEventLoop.ALLOWED_PRIORITIES::contains) ? (corePriorities.equals(EnumSet.of(HandlerPriority.MEDIUM)) ? new MediumEventLoop(this, this.nameWithSlash() + "core-event-loop", pauser, daemon, binding) : new VanillaEventLoop(this, this.nameWithSlash() + "core-event-loop", pauser, 1L, daemon, binding, priorities)) : null;
            closeable.add(this.core);
            this.monitor = new MonitorEventLoop(this, this.nameWithSlash() + "~monitor", Pauser.millis(Integer.getInteger("monitor.interval", 10)));
            closeable.add(this.monitor);
            if (this.core != null) {
                this.monitor.addHandler(new PauserMonitor(pauser, this.nameWithSlash() + "core-pauser", 300));
            }
            this.blocking = priorities.contains((Object)HandlerPriority.BLOCKING) ? new BlockingEventLoop(this, this.nameWithSlash() + "blocking-event-loop", blockingPauserSupplier.get()) : null;
            closeable.add(this.blocking);
            if (priorities.contains((Object)HandlerPriority.CONCURRENT)) {
                IntStream.range(0, concThreadsNum).forEach(i -> this.concThreads.add(null));
            }
            this.singleThreadedCheckDisabled(true);
            closeable.clear();
        }
        finally {
            Closeable.closeQuietly(closeable);
        }
    }

    @Deprecated
    public EventGroup(boolean daemon) {
        this(daemon, false);
    }

    @Deprecated
    public EventGroup(boolean daemon, boolean binding) {
        this(daemon, Pauser.balanced(), binding);
    }

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding) {
        this(daemon, pauser, binding, -1, -1, "");
    }

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, String name) {
        this(daemon, pauser, binding, -1, -1, name);
    }

    @Deprecated
    public EventGroup(boolean daemon, @NotNull Pauser pauser, boolean binding, int bindingCpuCore, int bindingCpuReplication, String name) {
        this(daemon, pauser, bindingCpuCore != -1 ? Integer.toString(bindingCpuCore) : (binding ? "any" : "none"), bindingCpuReplication != -1 ? Integer.toString(bindingCpuReplication) : "none", name, CONC_THREADS, EnumSet.allOf(HandlerPriority.class));
    }

    public static EventGroupBuilder builder() {
        return EventGroupBuilder.builder();
    }

    private synchronized VanillaEventLoop getReplication() {
        if (this.replication == null) {
            Pauser newReplicationPauser = this.replicationPauser != null ? this.replicationPauser : Pauser.balancedUpToMillis(REPLICATION_EVENT_PAUSE_TIME);
            this.replication = new VanillaEventLoop(this, this.nameWithSlash() + "replication-event-loop", newReplicationPauser, REPLICATION_EVENT_PAUSE_TIME.intValue(), this.daemon, this.bindingReplication, EnumSet.of(HandlerPriority.REPLICATION, HandlerPriority.REPLICATION_TIMER));
            this.addThreadMonitoring(REPLICATION_MONITOR_INTERVAL_MS, this.replication);
            if (this.isAlive()) {
                this.replication.start();
            }
            this.monitor.addHandler(new PauserMonitor(newReplicationPauser, this.nameWithSlash() + "replication pauser", 300));
        }
        return this.replication;
    }

    private void addThreadMonitoring(long replicationMonitorIntervalMs, CoreEventLoop replication) {
        if (ENABLE_LOOP_BLOCK_MONITOR) {
            this.monitor.addHandler(new ThreadMonitorHarness(new EventLoopThreadHolder(TimeUnit.NANOSECONDS.convert(replicationMonitorIntervalMs, TimeUnit.MILLISECONDS), replication)));
        }
    }

    private synchronized VanillaEventLoop getConcThread(int n) {
        VanillaEventLoop loop = this.concThreads.get(n);
        if (loop == null) {
            loop = new VanillaEventLoop(this, this.nameWithSlash() + "conc-event-loop-" + n, this.concPauserSupplier.get(), REPLICATION_EVENT_PAUSE_TIME.intValue(), this.daemon, this.concBinding, EnumSet.of(HandlerPriority.CONCURRENT));
            this.concThreads.set(n, loop);
            this.addThreadMonitoring(REPLICATION_MONITOR_INTERVAL_MS, loop);
            if (this.isAlive()) {
                loop.start();
            }
            this.monitor.addHandler(new PauserMonitor(this.pauser, this.nameWithSlash() + "conc-event-loop-" + n + " pauser", 300));
        }
        return loop;
    }

    @Override
    public void unpause() {
        this.pauser.unpause();
        if (this.replication != null) {
            this.replication.unpause();
        }
    }

    @Override
    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        HandlerPriority t1 = handler.priority();
        switch (t1) {
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                if (this.core == null) {
                    throw new IllegalStateException("Cannot add " + (Object)((Object)t1) + " " + handler + " to " + this.name);
                }
                this.core.addHandler(handler);
                break;
            }
            case BLOCKING: {
                if (this.blocking == null) {
                    throw new IllegalStateException("Cannot add BLOCKING " + handler + " to " + this.name);
                }
                this.blocking.addHandler(handler);
                break;
            }
            case REPLICATION: 
            case REPLICATION_TIMER: {
                if (t1 == HandlerPriority.REPLICATION && !this.priorities.contains((Object)HandlerPriority.REPLICATION)) {
                    throw new IllegalStateException("Cannot add REPLICATION " + handler + " to " + this.name);
                }
                if (t1 == HandlerPriority.REPLICATION_TIMER && !this.priorities.contains((Object)HandlerPriority.REPLICATION_TIMER)) {
                    throw new IllegalStateException("Cannot add REPLICATION_TIMER " + handler + " to " + this.name);
                }
                this.getReplication().addHandler(handler);
                break;
            }
            case CONCURRENT: {
                if (this.concThreads.isEmpty()) {
                    throw new IllegalStateException("Cannot add CONCURRENT " + handler + " to " + this.name);
                }
                this.getConcThread(this.counter.getAndIncrement() % this.concThreads.size()).addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + (Object)((Object)handler.priority()));
            }
        }
    }

    public void setupTimeLimitMonitor(long timeLimitNS, LongSupplier timeOfStart) {
        this.throwExceptionIfClosed();
        this.addTimingMonitor(this.name + "-monitor", timeLimitNS, timeOfStart, this.core::thread);
    }

    public void addTimingMonitor(String description, long timeLimitNS, LongSupplier timeSupplier, Supplier<Thread> threadSupplier) {
        this.milliPauser.minPauseTimeMS((timeLimitNS + 999999L) / 1000000L);
        this.addHandler(ThreadMonitors.forThread(description, timeLimitNS, timeSupplier, threadSupplier));
    }

    @Override
    protected void performStart() {
        if (this.core != null) {
            this.core.start();
        }
        if (this.blocking != null) {
            this.blocking.start();
        }
        if (this.replication != null) {
            this.replication.start();
        }
        for (VanillaEventLoop concThread : this.concThreads) {
            if (concThread == null) continue;
            concThread.start();
        }
        this.monitor.start();
        if (this.core != null) {
            this.addThreadMonitoring(MONITOR_INTERVAL_MS, this.core);
        }
        TimingPauser timeoutPauser = Pauser.sleepy();
        while (!this.isAlive()) {
            try {
                timeoutPauser.pause(WAIT_TO_START_MS, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                Jvm.error().on(EventGroup.class, String.format("Timed out waiting for start!%n%s%n%n%s%n%n", EventLoopStateRenderer.INSTANCE.render("Core", this.core), EventLoopStateRenderer.INSTANCE.render("Monitor", this.monitor)));
                throw Jvm.rethrow(e);
            }
        }
    }

    @Override
    protected void performStopFromNew() {
        this.performStop();
    }

    @Override
    protected void performStopFromStarted() {
        this.performStop();
    }

    private void performStop() {
        this.monitor.stop();
        EventLoops.stopAll(this.concThreads, this.replication, this.core, this.blocking);
    }

    @Override
    public boolean isAlive() {
        return (this.core == null ? this.monitor : this.core).isAlive();
    }

    @Override
    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly(this.core, this.monitor, this.replication, this.blocking);
        Closeable.closeQuietly(this.concThreads);
        this.awaitTermination();
    }
}

