/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.token;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedWriteConf;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterContainer;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.apache.cassandra.spark.bulkwriter.token.ConsistencyLevel;
import org.apache.cassandra.spark.bulkwriter.token.ReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.SingleClusterReplicaAwareFailureHandler;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.spark.common.model.CassandraInstance;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.Nullable;

public class MultiClusterReplicaAwareFailureHandler<I extends CassandraInstance>
extends ReplicaAwareFailureHandler<I> {
    private final MultiClusterContainer<SingleClusterReplicaAwareFailureHandler<I>> failureHandlers = new MultiClusterContainer();
    private final Partitioner partitioner;

    public MultiClusterReplicaAwareFailureHandler(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public synchronized void addFailure(Range<BigInteger> tokenRange, I instance, String errMessage) {
        String clusterId = instance.clusterId();
        this.failureHandlers.updateValue(clusterId, handler -> {
            SingleClusterReplicaAwareFailureHandler<CassandraInstance> h = handler;
            if (handler == null) {
                h = new SingleClusterReplicaAwareFailureHandler<CassandraInstance>(this.partitioner, clusterId);
            }
            h.addFailure(tokenRange, (CassandraInstance)instance, errMessage);
            return h;
        });
    }

    @Override
    public synchronized Set<I> getFailedInstances() {
        HashSet failedInstances = new HashSet();
        this.failureHandlers.forEach((ignored, handler) -> failedInstances.addAll(handler.getFailedInstances()));
        return failedInstances;
    }

    @Override
    public synchronized List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> getFailedRanges(TokenRangeMapping<I> tokenRangeMapping, JobInfo job, ClusterInfo cluster) {
        if (!job.isCoordinatedWriteEnabled()) {
            SingleClusterReplicaAwareFailureHandler<I> singleCluster = this.failureHandlers.getValueOrNull(null);
            return singleCluster == null ? Collections.emptyList() : singleCluster.getFailedRanges(tokenRangeMapping, job, cluster);
        }
        ArrayList<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> failurePerRanges = new ArrayList<ReplicaAwareFailureHandler.ConsistencyFailurePerRange>();
        CoordinatedWriteConf coordinatedWriteConf = job.coordinatedWriteConf();
        Preconditions.checkState((coordinatedWriteConf != null ? 1 : 0) != 0, (Object)"CoordinatedWriteConf is absent for multi-cluster write");
        Preconditions.checkState((boolean)(cluster instanceof MultiClusterSupport), (Object)"Not a MultiClusterSupport for multi-cluster write");
        MultiClusterSupport group = (MultiClusterSupport)((Object)cluster);
        this.failureHandlers.forEach((clusterId, handler) -> {
            CoordinatedWriteConf.ClusterConf clusterConf = coordinatedWriteConf.cluster((String)clusterId);
            ClusterInfo clusterInfo = (ClusterInfo)group.getValueOrThrow((String)clusterId);
            ReplicationFactor rf = clusterInfo.replicationFactor();
            failurePerRanges.addAll(handler.getFailedRangesInternal(tokenRangeMapping, job.getConsistencyLevel(), clusterConf.localDc(), rf));
        });
        return failurePerRanges;
    }

    @Override
    protected List<ReplicaAwareFailureHandler.ConsistencyFailurePerRange> getFailedRangesInternal(TokenRangeMapping<I> tokenRangeMapping, ConsistencyLevel cl, @Nullable String localDC, ReplicationFactor replicationFactor) {
        throw new UnsupportedOperationException("Not implemented for MultiClusterReplicaAwareFailureHandler");
    }
}

