/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.DataGenerationUtils;
import org.apache.cassandra.analytics.ResiliencyTestBase;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.IInstance;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class BulkWriteDownInstanceTest
extends SharedClusterSparkIntegrationTestBase {
    Set<IInstance> downInstances = new HashSet<IInstance>();

    BulkWriteDownInstanceTest() {
    }

    @ParameterizedTest(name="{index} => instanceDownCount={0}, {1}")
    @MethodSource(value={"testInputs"})
    void testHandlingOfDownedCassandraInstances(int instanceDownCount, TestConsistencyLevel cl) {
        this.stopCassandraInstancesForTest(instanceDownCount);
        QualifiedName tableName = ResiliencyTestBase.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        SparkSession spark = this.getOrCreateSparkSession();
        Dataset<Row> df = DataGenerationUtils.generateCourseData(spark, 1000);
        DataFrameWriter dfWriter = this.bulkWriterDataFrameWriter(df, tableName).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name());
        if (BulkWriteDownInstanceTest.isFailureExpected(instanceDownCount, cl)) {
            this.sparkTestUtils.assertExpectedBulkWriteFailure(cl.writeCL.name(), (DataFrameWriter<Row>)dfWriter);
        } else {
            dfWriter.save();
            this.sparkTestUtils.validateWrites(df.collectAsList(), this.queryAllData(tableName, cl.readCL));
        }
    }

    static boolean isFailureExpected(int instanceDownCount, TestConsistencyLevel cl) {
        if (instanceDownCount == 2) {
            return cl.writeCL != ConsistencyLevel.ONE;
        }
        if (instanceDownCount == 1) {
            return cl.writeCL == ConsistencyLevel.ALL;
        }
        return false;
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        BulkWriteDownInstanceTest.testConsistencyLevels().forEach(consistencyLevel -> {
            QualifiedName tableName = ResiliencyTestBase.uniqueTestTableFullName("spark_test", consistencyLevel.readCL, consistencyLevel.writeCL);
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return super.testClusterConfiguration().nodesPerDc(3);
    }

    void stopCassandraInstancesForTest(int instanceDownCount) {
        block0: while (instanceDownCount > this.downInstances.size()) {
            for (IInstance instance : this.cluster) {
                if (!this.downInstances.add(instance)) continue;
                this.cluster.stopUnchecked(instance);
                continue block0;
            }
        }
    }

    static Stream<Arguments> testInputs() {
        return IntStream.rangeClosed(0, 2).mapToObj(instanceDownCount -> new AbstractMap.SimpleEntry<Integer, List<TestConsistencyLevel>>(instanceDownCount, BulkWriteDownInstanceTest.testConsistencyLevels())).flatMap(pair -> ((List)pair.getValue()).stream().map(cl -> Arguments.of((Object[])new Object[]{pair.getKey(), cl})));
    }

    static List<TestConsistencyLevel> testConsistencyLevels() {
        return Arrays.asList(TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ALL), TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM), TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ONE));
    }
}

