/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.sidecar;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.cdc.kafka.KafkaOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SidecarCdcOptions
extends KafkaOptions {
    public static final String DEFAULT_JOB_ID = "test-job";
    public static final int DEFAULT_MAX_WATERMARKER_SIZE = 400000;
    public static final SidecarCdcOptions DEFAULT = new SidecarCdcOptions(){};

    @Nullable
    default public String kafkaTopic() {
        return null;
    }

    @NotNull
    default public TopicFormatType topicFormat() {
        return TopicFormatType.STATIC;
    }

    default public boolean cdcEnabled() {
        return true;
    }

    default public String jobId() {
        return DEFAULT_JOB_ID;
    }

    default public Map<String, Object> kafkaConfigs() {
        return Collections.emptyMap();
    }

    default public Map<String, Object> cdcConfigs() {
        return Collections.emptyMap();
    }

    default public boolean logOnly() {
        return false;
    }

    default public String dc() {
        return "DATACENTER1";
    }

    default public Duration watermarkWindow() {
        return Duration.ofHours(4L);
    }

    default public int maxRecordSizeBytes() {
        return -1;
    }

    @Nullable
    default public String compression() {
        return null;
    }

    default public boolean failOnRecordTooLargeError() {
        return false;
    }

    default public boolean failOnKafkaError() {
        return true;
    }

    default public boolean isConfigReady() {
        return true;
    }

    default public Duration minDelayBetweenMicroBatches() {
        return Duration.ofMillis(1000L);
    }

    default public int maxCommitLogsPerInstance() {
        return 4;
    }

    default public int maxWatermarkerSize() {
        return 400000;
    }

    default public boolean persistEnabled() {
        return true;
    }

    default public Duration persistDelay() {
        return Duration.ofMillis(1000L);
    }

    public static enum TopicFormatType {
        STATIC,
        KEYSPACE,
        KEYSPACETABLE,
        TABLE,
        MAP;

    }
}

