/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types;

import java.util.Date;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.converter.types.LongFeatures;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.jetbrains.annotations.NotNull;

public class SparkTimestamp
implements LongFeatures {
    public static final SparkTimestamp INSTANCE = new SparkTimestamp();

    private SparkTimestamp() {
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.TimestampType;
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return ((Date)value).getTime() * 1000L;
    }

    @Override
    public Object nativeSparkSqlRowValue(Row row, int position) {
        return new Date(row.getTimestamp(position).getTime());
    }

    @Override
    public Object toTestRowType(Object value) {
        if (value instanceof Date) {
            return value;
        }
        return new Date((Long)value / 1000L);
    }
}

