/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.annotations.VisibleForTesting;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;

public final class UUIDs {
    private static final long START_EPOCH = UUIDs.makeEpoch();
    private static final long CLOCK_SEQ_AND_NODE = UUIDs.makeClockSeqAndNode();

    private UUIDs() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static UUID startOf(long timestamp) {
        return new UUID(UUIDs.makeMSB(UUIDs.fromUnixTimestamp(timestamp)), CLOCK_SEQ_AND_NODE);
    }

    @VisibleForTesting
    static long fromUnixTimestamp(long timestamp) {
        return (timestamp - START_EPOCH) * 10000L;
    }

    @VisibleForTesting
    static long makeMSB(long timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp) << 32;
        msb |= (0xFFFF00000000L & timestamp) >>> 16;
        msb |= (0xFFF000000000000L & timestamp) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeEpoch() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        calendar.set(1, 1582);
        calendar.set(2, 9);
        calendar.set(5, 15);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private static long makeClockSeqAndNode() {
        SecureRandom secureRandom = new SecureRandom();
        long clock = secureRandom.nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= secureRandom.nextLong();
    }
}

