/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.bridge.TokenRange;
import org.jetbrains.annotations.Nullable;

public class KryoUtils {
    private KryoUtils() {
    }

    public static <T> byte[] serializeToBytes(Kryo kryo, T obj, Serializer<T> serializer) {
        try (Output out = KryoUtils.serialize(kryo, obj, serializer);){
            byte[] byArray = out.getBuffer();
            return byArray;
        }
    }

    public static <T> Output serialize(Kryo kryo, Object obj, Serializer<T> serializer) {
        try (Output out = new Output(1024, -1);){
            kryo.writeObject(out, obj, serializer);
            Output output = out;
            return output;
        }
    }

    public static <T> byte[] serializeToBytes(Kryo kryo, T obj) {
        try (Output out = KryoUtils.serialize(kryo, obj);){
            byte[] byArray = out.getBuffer();
            return byArray;
        }
    }

    public static Output serialize(Kryo kryo, Object obj) {
        try (Output out = new Output(1024, -1);){
            kryo.writeObject(out, obj);
            Output output = out;
            return output;
        }
    }

    public static <T> T deserialize(Kryo kryo, byte[] ar, Class<T> type) {
        try (Input in = new Input(ar, 0, ar.length);){
            Object object = kryo.readObject(in, type);
            return (T)object;
        }
    }

    public static <T> T deserialize(Kryo kryo, Output out, Class<T> type) {
        try (Input in = new Input(out.getBuffer(), 0, (int)out.total());){
            Object object = kryo.readObject(in, type);
            return (T)object;
        }
    }

    public static <T> T deserialize(Kryo kryo, ByteBuffer buf, Class<T> type, Serializer<T> serializer) {
        byte[] ar = new byte[buf.remaining()];
        buf.get(ar);
        return KryoUtils.deserialize(kryo, ar, type, serializer);
    }

    public static <T> T deserialize(Kryo kryo, byte[] ar, Class<T> type, Serializer<T> serializer) {
        try (Input in = new Input(ar, 0, ar.length);){
            Object object = kryo.readObject(in, type, serializer);
            return (T)object;
        }
    }

    public static void writeRange(Output out, @Nullable TokenRange range) {
        if (range != null) {
            KryoUtils.writeBigInteger(out, range.lowerEndpoint());
            KryoUtils.writeBigInteger(out, range.upperEndpoint());
        } else {
            out.writeByte(-1);
        }
    }

    @Nullable
    public static TokenRange readRange(Input in) {
        BigInteger lower = KryoUtils.readBigInteger(in);
        if (lower != null) {
            return TokenRange.openClosed(lower, Objects.requireNonNull(KryoUtils.readBigInteger(in)));
        }
        return null;
    }

    public static void writeBigInteger(Output out, BigInteger bi) {
        byte[] ar = bi.toByteArray();
        out.writeByte(ar.length);
        out.writeBytes(ar);
    }

    @Nullable
    public static BigInteger readBigInteger(Input in) {
        byte len = in.readByte();
        if (len > 0) {
            byte[] ar = new byte[len];
            in.readBytes(ar);
            return new BigInteger(ar);
        }
        return null;
    }
}

