/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.UUID;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.repair.PreviewRepairConflictWithIncrementalRepairException;
import org.apache.cassandra.repair.consistent.ConsistentSession;
import org.apache.cassandra.repair.consistent.LocalSession;
import org.apache.cassandra.service.ActiveRepairService;

public final class PreviewKind
extends Enum<PreviewKind> {
    public static final /* enum */ PreviewKind NONE = new PreviewKind(0, sstable -> {
        throw new RuntimeException("Can't get preview predicate for preview kind NONE");
    });
    public static final /* enum */ PreviewKind ALL = new PreviewKind(1, Predicates.alwaysTrue());
    public static final /* enum */ PreviewKind UNREPAIRED = new PreviewKind(2, sstable -> !sstable.isRepaired());
    public static final /* enum */ PreviewKind REPAIRED = new PreviewKind(3, new PreviewRepairedSSTablePredicate());
    private final int serializationVal;
    private final Predicate<SSTableReader> predicate;
    private static final /* synthetic */ PreviewKind[] $VALUES;

    public static PreviewKind[] values() {
        return (PreviewKind[])$VALUES.clone();
    }

    public static PreviewKind valueOf(String name) {
        return Enum.valueOf(PreviewKind.class, name);
    }

    private PreviewKind(int serializationVal, Predicate<SSTableReader> predicate) {
        assert (this.ordinal() == serializationVal);
        this.serializationVal = serializationVal;
        this.predicate = predicate;
    }

    public int getSerializationVal() {
        return this.serializationVal;
    }

    public static PreviewKind deserialize(int serializationVal) {
        return PreviewKind.values()[serializationVal];
    }

    public boolean isPreview() {
        return this != NONE;
    }

    public String logPrefix() {
        return this.isPreview() ? "preview repair" : "repair";
    }

    public String logPrefix(UUID sessionId) {
        return '[' + this.logPrefix() + " #" + sessionId.toString() + ']';
    }

    public Predicate<SSTableReader> predicate() {
        return this.predicate;
    }

    static {
        $VALUES = new PreviewKind[]{NONE, ALL, UNREPAIRED, REPAIRED};
    }

    private static class PreviewRepairedSSTablePredicate
    implements Predicate<SSTableReader> {
        private PreviewRepairedSSTablePredicate() {
        }

        @Override
        public boolean apply(SSTableReader sstable) {
            StatsMetadata sstableMetadata = sstable.getSSTableMetadata();
            if (sstableMetadata.pendingRepair != null) {
                LocalSession session = ActiveRepairService.instance.consistent.local.getSession(sstableMetadata.pendingRepair);
                if (session == null) {
                    return false;
                }
                if (session.getState() == ConsistentSession.State.FINALIZED) {
                    return true;
                }
                if (session.getState() != ConsistentSession.State.FAILED) {
                    throw new PreviewRepairConflictWithIncrementalRepairException(String.format("SSTable %s is marked pending for non-finalized incremental repair session %s, failing preview repair", sstable, sstableMetadata.pendingRepair));
                }
            }
            return sstableMetadata.repairedAt != 0L;
        }
    }
}

