/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

final class AggregateFunctionSelector
extends AbstractFunctionSelector<AggregateFunction> {
    private final AggregateFunction.Aggregate aggregate;

    public boolean isAggregate() {
        return true;
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
        int m3 = this.argSelectors.size();
        for (int i = 0; i < m3; ++i) {
            Selector s2 = (Selector)this.argSelectors.get(i);
            s2.addInput(protocolVersion, rs);
            this.setArg(i, s2.getOutput(protocolVersion));
            s2.reset();
        }
        this.aggregate.addInput(protocolVersion, this.args());
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        return this.aggregate.compute(protocolVersion);
    }

    @Override
    public void reset() {
        this.aggregate.reset();
    }

    AggregateFunctionSelector(Function fun, List<Selector> argSelectors) throws InvalidRequestException {
        super((AggregateFunction)fun, argSelectors);
        this.aggregate = ((AggregateFunction)this.fun).newAggregate();
    }
}

